/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.requirements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import net.apartium.cocoabeans.CollectionHelpers;
import net.apartium.cocoabeans.commands.requirements.Requirement;
import net.apartium.cocoabeans.commands.requirements.RequirementEvaluationContext;
import net.apartium.cocoabeans.commands.requirements.RequirementResult;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class RequirementSet
implements Set<Requirement> {
    private final Requirement[] requirements;

    @SafeVarargs
    public RequirementSet(Collection<Requirement> ... requirements) {
        int size = 0;
        for (Collection<Requirement> collection : requirements) {
            size += collection.size();
        }
        this.requirements = new Requirement[size];
        int index = 0;
        for (Collection<Requirement> collection : requirements) {
            for (Requirement requirement : collection) {
                this.requirements[index++] = requirement;
            }
        }
    }

    public RequirementSet(Requirement ... requirements) {
        for (int i = 0; i < requirements.length - 1; ++i) {
            for (int j = i + 1; j < requirements.length; ++j) {
                if (!requirements[i].equals(requirements[j])) continue;
                throw new RuntimeException("There's duplicated permission in the set: " + String.valueOf(requirements[i]));
            }
        }
        this.requirements = Arrays.copyOf(requirements, requirements.length);
    }

    public RequirementSet() {
        this.requirements = new Requirement[0];
    }

    @Override
    public int size() {
        return this.requirements.length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object obj) {
        for (Requirement requirement : this.requirements) {
            if (!requirement.equals(obj)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.requirements);
    }

    @Override
    @NotNull
    public Iterator<Requirement> iterator() {
        return Arrays.stream(this.requirements).iterator();
    }

    @NotNull
    public @NotNull Requirement @NotNull [] toArray() {
        return Arrays.copyOf(this.requirements, this.requirements.length);
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] ts) {
        if (ts.length < this.requirements.length) {
            return Arrays.copyOf(this.requirements, this.requirements.length, ts.getClass());
        }
        System.arraycopy(this.requirements, 0, ts, 0, this.requirements.length);
        if (ts.length > this.requirements.length) {
            ts[this.requirements.length] = null;
        }
        return ts;
    }

    @Override
    public boolean add(Requirement permission) {
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        for (Object value : collection) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Requirement> collection) {
        return false;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        return false;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequirementSet other = (RequirementSet)o;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        return CollectionHelpers.equalsArray(this.requirements, other.requirements);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.requirements);
    }

    public RequirementResult meetsRequirements(RequirementEvaluationContext context) {
        ArrayList<RequirementResult.Value> values = new ArrayList<RequirementResult.Value>();
        for (Requirement requirement : this.requirements) {
            RequirementResult requirementResult = requirement.meetsRequirement(context);
            if (!requirementResult.meetRequirement()) {
                return requirementResult;
            }
            values.addAll(Arrays.asList(requirementResult.getValues()));
        }
        return RequirementResult.meet(values.toArray(new RequirementResult.Value[0]));
    }
}

