/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.requirements;

import net.apartium.cocoabeans.commands.exception.BadCommandResponse;
import org.jetbrains.annotations.ApiStatus;

public class RequirementResult {
    private final BadCommandResponse error;
    private final boolean meetRequirement;
    private final Value[] values;

    private RequirementResult(BadCommandResponse error, boolean meetRequirement, Value ... values) {
        this.error = error;
        this.meetRequirement = meetRequirement;
        this.values = values;
    }

    public BadCommandResponse getError() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public boolean meetRequirement() {
        return this.meetRequirement;
    }

    public Value[] getValues() {
        return this.values;
    }

    @ApiStatus.AvailableSince(value="0.0.30")
    public static RequirementResult error(BadCommandResponse error) {
        return new RequirementResult(error, false, new Value[0]);
    }

    @ApiStatus.AvailableSince(value="0.0.30")
    public static RequirementResult meet() {
        return new RequirementResult(null, true, new Value[0]);
    }

    @ApiStatus.AvailableSince(value="0.0.30")
    public static RequirementResult meet(Value ... values) {
        return new RequirementResult(null, true, values);
    }

    @ApiStatus.AvailableSince(value="0.0.30")
    public static Value valueOf(Object value, Class<?> clazz) {
        return new Value(value, clazz);
    }

    @ApiStatus.AvailableSince(value="0.0.30")
    public static Value valueOf(Object value) {
        return new Value(value, value.getClass());
    }

    @ApiStatus.AvailableSince(value="0.0.30")
    public record Value(Object value, Class<?> clazz) {
    }
}

