/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import org.jetbrains.annotations.ApiStatus;

public class StringsParser
extends ArgumentParser<String> {
    public static final String DEFAULT_KEYWORD = "strings";

    @ApiStatus.AvailableSince(value="0.0.36")
    public StringsParser(int priority, String keyword) {
        super(keyword, String.class, priority);
    }

    public StringsParser(int priority) {
        this(priority, DEFAULT_KEYWORD);
    }

    @Override
    public Optional<ArgumentParser.ParseResult<String>> parse(CommandProcessingContext processingContext) {
        List<String> args = processingContext.args();
        int startIndex = processingContext.index();
        CharSequence[] newArgs = new String[args.size() - startIndex];
        System.arraycopy(args.toArray(new String[0]), startIndex, newArgs, 0, newArgs.length);
        return Optional.of(new ArgumentParser.ParseResult<String>(String.join((CharSequence)" ", newArgs), args.size()));
    }

    @Override
    public OptionalInt tryParse(CommandProcessingContext processingContext) {
        List<String> args = processingContext.args();
        return OptionalInt.of(args.size());
    }

    @Override
    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
        List<String> args = processingContext.args();
        return Optional.of(new ArgumentParser.TabCompletionResult(Set.of(), args.size()));
    }
}

