/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.exception.BadCommandResponse;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.36")
class LongStringParser
extends ArgumentParser<String> {
    public static final String DEFAULT_KEYWORD = "long-string";
    public static final char ESCAPE_CHARACTER = '\\';
    public static final char QUOTATION_CHARACTER = '\"';
    public static final char NEW_LINE_CHARACTER = 'n';
    public static final String INVALID_QUOTATION_MESSAGE = "Invalid quoted string";
    private final boolean paragraphMode;

    public LongStringParser(int priority, String keyword, boolean paragraphMode) {
        super(keyword, String.class, priority);
        this.paragraphMode = paragraphMode;
    }

    public LongStringParser(int priority, String keyword) {
        this(priority, keyword, false);
    }

    public LongStringParser(int priority, boolean paragraphMode) {
        this(priority, DEFAULT_KEYWORD, paragraphMode);
    }

    public LongStringParser(int priority) {
        this(priority, DEFAULT_KEYWORD);
    }

    @Override
    public Optional<ArgumentParser.ParseResult<String>> parse(CommandProcessingContext processingContext) {
        List<String> args = processingContext.args();
        int index = processingContext.index();
        if (index >= args.size()) {
            return Optional.empty();
        }
        if (args.get(index).isEmpty()) {
            return Optional.of(new ArgumentParser.ParseResult<String>("", index + 1));
        }
        int lastIndex = index;
        StringBuilder resultBuilder = new StringBuilder();
        String firstArg = args.get(index);
        boolean quoted = firstArg.charAt(0) == '\"';
        ArrayDeque<Character> escapeCharacters = new ArrayDeque<Character>();
        if (quoted) {
            escapeCharacters.addLast(Character.valueOf('\"'));
            firstArg = firstArg.substring(1);
        }
        int length = !quoted ? index + 1 : args.size();
        int i = index;
        while (i < length) {
            String arg = i == index ? firstArg : args.get(i);
            lastIndex = i++;
            ProcessResult processResult = this.processArg(processingContext, arg, resultBuilder, escapeCharacters);
            if (processResult == ProcessResult.FAILED) {
                return Optional.empty();
            }
            if (processResult == ProcessResult.FINISHED) break;
        }
        if (!escapeCharacters.isEmpty()) {
            this.reportError(processingContext, INVALID_QUOTATION_MESSAGE);
            return Optional.empty();
        }
        return Optional.of(new ArgumentParser.ParseResult<String>(this.toString(resultBuilder), lastIndex + 1));
    }

    @ApiStatus.Internal
    private String toString(StringBuilder resultBuilder) {
        if (resultBuilder.isEmpty()) {
            return "";
        }
        if (resultBuilder.charAt(resultBuilder.length() - 1) == ' ') {
            return resultBuilder.substring(0, resultBuilder.length() - 1);
        }
        return resultBuilder.toString();
    }

    @ApiStatus.Internal
    private ProcessResult processArg(CommandProcessingContext processingContext, String arg, StringBuilder resultBuilder, Deque<Character> escapeCharacters) {
        for (int i = 0; i < arg.length(); ++i) {
            boolean isLastChar;
            char currentChar = arg.charAt(i);
            ProcessResult processResult = this.processChar(processingContext, resultBuilder, escapeCharacters, currentChar, isLastChar = i == arg.length() - 1);
            if (processResult == ProcessResult.CONTINUE_NO_SPACE) {
                return ProcessResult.CONTINUE;
            }
            if (processResult == ProcessResult.FAILED) {
                return ProcessResult.FAILED;
            }
            if (processResult != ProcessResult.FINISHED) continue;
            return ProcessResult.FINISHED;
        }
        resultBuilder.append(" ");
        return ProcessResult.CONTINUE;
    }

    private ProcessResult processChar(CommandProcessingContext processingContext, StringBuilder resultBuilder, Deque<Character> escapeCharacters, char currentChar, boolean isLastChar) {
        ProcessResult processResult;
        if (currentChar == '\"') {
            return this.handleQuote(processingContext, resultBuilder, escapeCharacters, isLastChar);
        }
        if (currentChar == '\\') {
            this.handleBackSlash(resultBuilder, escapeCharacters);
            return ProcessResult.CONTINUE;
        }
        if (this.paragraphMode && currentChar == 'n' && (processResult = this.handleNewLine(resultBuilder, escapeCharacters, isLastChar)) != ProcessResult.IGNORE) {
            return processResult;
        }
        resultBuilder.append(currentChar);
        return ProcessResult.CONTINUE;
    }

    @ApiStatus.Internal
    private ProcessResult handleQuote(CommandProcessingContext processingContext, StringBuilder resultBuilder, Deque<Character> escapeCharacters, boolean isLastChar) {
        if (escapeCharacters.isEmpty()) {
            this.reportError(processingContext, INVALID_QUOTATION_MESSAGE);
            return ProcessResult.FAILED;
        }
        return switch (escapeCharacters.peekLast().charValue()) {
            case '\"' -> {
                escapeCharacters.removeLast();
                if (!escapeCharacters.isEmpty()) {
                    this.reportError(processingContext, INVALID_QUOTATION_MESSAGE);
                    yield ProcessResult.FAILED;
                }
                if (!isLastChar) {
                    this.reportError(processingContext, "Invalid quoted string in the middle");
                    yield ProcessResult.FAILED;
                }
                resultBuilder.append(" ");
                yield ProcessResult.FINISHED;
            }
            case '\\' -> {
                escapeCharacters.removeLast();
                resultBuilder.append('\"');
                yield ProcessResult.CONTINUE;
            }
            default -> {
                this.reportError(processingContext, INVALID_QUOTATION_MESSAGE);
                yield ProcessResult.FAILED;
            }
        };
    }

    @ApiStatus.Internal
    private void handleBackSlash(StringBuilder resultBuilder, Deque<Character> escapeCharacters) {
        if (!escapeCharacters.isEmpty() && escapeCharacters.peekLast().charValue() == '\\') {
            escapeCharacters.removeLast();
            resultBuilder.append('\\');
            return;
        }
        escapeCharacters.addLast(Character.valueOf('\\'));
    }

    @ApiStatus.Internal
    private ProcessResult handleNewLine(StringBuilder resultBuilder, Deque<Character> escapeCharacters, boolean isLastChar) {
        if (escapeCharacters.isEmpty()) {
            return ProcessResult.IGNORE;
        }
        if (escapeCharacters.peekLast().charValue() != '\\') {
            return ProcessResult.IGNORE;
        }
        escapeCharacters.removeLast();
        resultBuilder.append("\n");
        if (isLastChar) {
            return ProcessResult.CONTINUE_NO_SPACE;
        }
        return ProcessResult.CONTINUE;
    }

    @ApiStatus.Internal
    private void reportError(CommandProcessingContext processingContext, String message) {
        processingContext.report(this, new BadCommandResponse(processingContext.label(), processingContext.args().toArray(new String[0]), processingContext.index(), message));
    }

    @Override
    public OptionalInt tryParse(CommandProcessingContext processingContext) {
        return this.parse(processingContext).map(ArgumentParser.ParseResult::newIndex).map(OptionalInt::of).orElse(OptionalInt.empty());
    }

    @Override
    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
        OptionalInt optionalInt = this.tryParse(processingContext);
        if (optionalInt.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ArgumentParser.TabCompletionResult(Set.of(), optionalInt.getAsInt()));
    }

    @ApiStatus.Internal
    private static enum ProcessResult {
        FAILED,
        IGNORE,
        CONTINUE_NO_SPACE,
        CONTINUE,
        FINISHED;

    }
}

