/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import net.apartium.cocoabeans.StringHelpers;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import org.jetbrains.annotations.ApiStatus;

public class LongParser
extends ArgumentParser<Long> {
    public static final String DEFAULT_KEYWORD = "long";

    @ApiStatus.AvailableSince(value="0.0.36")
    public LongParser(int priority, String keyword) {
        super(keyword, Long.TYPE, priority);
    }

    public LongParser(int priority) {
        this(priority, DEFAULT_KEYWORD);
    }

    @Override
    public Optional<ArgumentParser.ParseResult<Long>> parse(CommandProcessingContext processingContext) {
        int startIndex;
        List<String> args = processingContext.args();
        OptionalLong optionalLong = StringHelpers.parseLong(args.get(startIndex = processingContext.index()));
        if (optionalLong.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ArgumentParser.ParseResult<Long>(optionalLong.getAsLong(), startIndex + 1));
    }

    @Override
    public OptionalInt tryParse(CommandProcessingContext processingContext) {
        int startIndex;
        List<String> args = processingContext.args();
        OptionalLong optionalLong = StringHelpers.parseLong(args.get(startIndex = processingContext.index()));
        if (optionalLong.isEmpty()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(startIndex + 1);
    }

    @Override
    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
        int i;
        boolean isPositive;
        int index;
        List<String> args = processingContext.args();
        if (args.get(index = processingContext.index()).isEmpty()) {
            return Optional.of(new ArgumentParser.TabCompletionResult(Set.of("1", "2", "3", "4", "5", "6", "7", "8", "9", "-"), index + 1));
        }
        OptionalLong optionalLong = StringHelpers.parseLong(args.get(index));
        if (optionalLong.isEmpty()) {
            return Optional.empty();
        }
        long asLong = optionalLong.getAsLong();
        long asLongByTen = asLong * 10L;
        boolean bl = isPositive = asLong >= 0L;
        if (isPositive ? asLong > asLongByTen : asLong < asLongByTen) {
            return Optional.empty();
        }
        HashSet<String> result = new HashSet<String>();
        int n = i = asLong == 0L ? 1 : 0;
        while (i < 10) {
            long num = asLongByTen + (long)i;
            if (isPositive ? asLong > num : asLong < num) break;
            result.add(args.get(index) + i);
            ++i;
        }
        return Optional.of(new ArgumentParser.TabCompletionResult(result, index + 1));
    }
}

