/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.apartium.cocoabeans.StringHelpers;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import org.jetbrains.annotations.ApiStatus;

public class IntParser
extends ArgumentParser<Integer> {
    public static final String DEFAULT_KEYWORD = "int";

    @ApiStatus.AvailableSince(value="0.0.36")
    public IntParser(int priority, String keyword) {
        super(keyword, Integer.TYPE, priority);
    }

    public IntParser(int priority) {
        this(priority, DEFAULT_KEYWORD);
    }

    @Override
    public Optional<ArgumentParser.ParseResult<Integer>> parse(CommandProcessingContext processingContext) {
        int startIndex;
        List<String> args = processingContext.args();
        OptionalInt optionalInt = StringHelpers.parseInteger(args.get(startIndex = processingContext.index()));
        if (optionalInt.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ArgumentParser.ParseResult<Integer>(optionalInt.getAsInt(), startIndex + 1));
    }

    @Override
    public OptionalInt tryParse(CommandProcessingContext processingContext) {
        int startIndex;
        List<String> args = processingContext.args();
        OptionalInt optionalInt = StringHelpers.parseInteger(args.get(startIndex = processingContext.index()));
        if (optionalInt.isEmpty()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(startIndex + 1);
    }

    @Override
    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
        int i;
        boolean isPositive;
        int index;
        List<String> args = processingContext.args();
        if (args.get(index = processingContext.index()).isEmpty()) {
            return Optional.of(new ArgumentParser.TabCompletionResult(Set.of("1", "2", "3", "4", "5", "6", "7", "8", "9", "-"), index + 1));
        }
        OptionalInt optionalInt = StringHelpers.parseInteger(args.get(index));
        if (optionalInt.isEmpty()) {
            return Optional.empty();
        }
        int asInt = optionalInt.getAsInt();
        int asIntByTen = asInt * 10;
        boolean bl = isPositive = asInt >= 0;
        if (isPositive ? asInt > asIntByTen : asInt < asIntByTen) {
            return Optional.empty();
        }
        HashSet<String> result = new HashSet<String>();
        int n = i = asInt == 0 ? 1 : 0;
        while (i < 10) {
            int num = asIntByTen + i;
            if (isPositive ? asInt > num : asInt < num) break;
            result.add(args.get(index) + i);
            ++i;
        }
        return Optional.of(new ArgumentParser.TabCompletionResult(result, index + 1));
    }
}

