/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.commands.parsers.CompoundParser;
import net.apartium.cocoabeans.commands.parsers.CompoundParserOption;
import net.apartium.cocoabeans.commands.requirements.RequirementEvaluationContext;
import net.apartium.cocoabeans.commands.requirements.RequirementResult;
import net.apartium.cocoabeans.commands.requirements.RequirementSet;
import net.apartium.cocoabeans.structs.Entry;

class CompoundParserBranchProcessor<T> {
    final List<Entry<RequirementSet, CompoundParserOption<T>>> objectMap = new ArrayList<Entry<RequirementSet, CompoundParserOption<T>>>();

    CompoundParserBranchProcessor() {
    }

    public Optional<CompoundParser.ParserResult> parse(CommandProcessingContext processingContext) {
        RequirementEvaluationContext requirementEvaluationContext = new RequirementEvaluationContext(processingContext.sender(), processingContext.label(), processingContext.args().toArray(new String[0]), processingContext.index());
        for (Entry<RequirementSet, CompoundParserOption<T>> entry : this.objectMap) {
            Optional<CompoundParser.ParserResult> result;
            RequirementResult requirementResult = entry.key().meetsRequirements(requirementEvaluationContext);
            if (!requirementResult.meetRequirement() || (result = entry.value().parse(processingContext)).isEmpty()) continue;
            for (RequirementResult.Value value : requirementResult.getValues()) {
                result.get().mappedByClass().computeIfAbsent(value.clazz(), clazz -> new ArrayList()).add(value.value());
            }
            return result;
        }
        return Optional.empty();
    }

    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
        RequirementEvaluationContext requirementEvaluationContext = new RequirementEvaluationContext(processingContext.sender(), processingContext.label(), processingContext.args().toArray(new String[0]), processingContext.index());
        HashSet<String> result = new HashSet<String>();
        int highestIndex = -1;
        for (Entry<RequirementSet, CompoundParserOption<T>> entry : this.objectMap) {
            Optional<ArgumentParser.TabCompletionResult> tabCompletion;
            if (!entry.key().meetsRequirements(requirementEvaluationContext).meetRequirement() || (tabCompletion = entry.value().tabCompletion(processingContext)).isEmpty()) continue;
            highestIndex = Math.max(highestIndex, tabCompletion.get().newIndex());
            result.addAll(tabCompletion.get().result());
        }
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ArgumentParser.TabCompletionResult(result, highestIndex));
    }
}

