/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import org.jetbrains.annotations.NotNull;

public abstract class ArgumentParser<T>
implements Comparable<ArgumentParser<?>> {
    private final String keyword;
    private final Class<T> clazz;
    private final int priority;

    protected ArgumentParser(String keyword, Class<T> clazz, int priority) {
        this.keyword = keyword;
        this.clazz = clazz;
        this.priority = priority;
    }

    public abstract Optional<ParseResult<T>> parse(CommandProcessingContext var1);

    public abstract OptionalInt tryParse(CommandProcessingContext var1);

    public abstract Optional<TabCompletionResult> tabCompletion(CommandProcessingContext var1);

    public Class<T> getArgumentType() {
        return this.clazz;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(@NotNull ArgumentParser<?> other) {
        return Integer.compare(this.priority, other.priority);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public record TabCompletionResult(Set<String> result, int newIndex) {
    }

    public record ParseResult<T>(T result, int newIndex) {
    }
}

