/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.lexer;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.apartium.cocoabeans.commands.RegisterArgumentParser;
import net.apartium.cocoabeans.commands.lexer.ArgumentParserToken;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.37")
public class SimpleArgumentParserToken
extends ArgumentParserToken {
    private static final Pattern PARAMETER_NAME_REGEX = Pattern.compile("^[a-zA-Z0-9_\\-]+:");
    private String parserKeyword;
    private String parameterName;
    private boolean optionalNotMatch;
    private boolean isOptional;

    public SimpleArgumentParserToken(int from, int to, String text) {
        super(from, to, text);
        String actualData = text.substring(from + 1, to - 1);
        this.setKeywordAndParameterName(actualData);
    }

    @Override
    public Optional<String> getParameterName() {
        return Optional.ofNullable(this.parameterName);
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public boolean optionalNotMatch() {
        return this.optionalNotMatch;
    }

    @Override
    public RegisterArgumentParser<?> getParser(Map<String, ArgumentParser<?>> parsers) {
        ArgumentParser<?> argumentParser = parsers.get(this.parserKeyword);
        if (argumentParser == null) {
            throw new IllegalArgumentException("Parser not found: " + this.parserKeyword);
        }
        return new RegisterArgumentParser(argumentParser, this.optionalNotMatch, this.isOptional, this.parameterName);
    }

    @Override
    public String getParserName() {
        return this.parserKeyword;
    }

    private void setKeywordAndOptionals(String keyword) {
        this.optionalNotMatch = keyword.startsWith("!") || keyword.startsWith("?!");
        this.isOptional = keyword.startsWith("?") || keyword.startsWith("!?");
        this.parserKeyword = keyword.substring((this.optionalNotMatch ? 1 : 0) + (this.isOptional ? 1 : 0));
    }

    private void setKeywordAndParameterName(String actualData) {
        String[] split = actualData.split("\\s+");
        if (split.length == 1) {
            this.setKeywordAndOptionals(split[0]);
            this.parameterName = null;
            return;
        }
        if (split.length != 2) {
            throw new IllegalArgumentException("Invalid argument parser token: " + actualData);
        }
        Matcher matcher = PARAMETER_NAME_REGEX.matcher(split[0]);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid parameter name: " + actualData);
        }
        this.setKeywordAndOptionals(split[1]);
        this.parameterName = split[0].substring(0, split[0].length() - 1);
    }

    public String toString() {
        return "SimpleArgumentParserToken{parameterName=" + this.parameterName + ", from=" + this.from + ", to=" + this.to + ", text='" + this.text + "', parserKeyword='" + this.parserKeyword + "', optionalNotMatch=" + this.optionalNotMatch + ", isOptional=" + this.isOptional + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleArgumentParserToken that = (SimpleArgumentParserToken)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && this.optionalNotMatch == that.optionalNotMatch && this.isOptional == that.isOptional && Objects.equals(this.text, that.text) && Objects.equals(this.parserKeyword, that.parserKeyword) && Objects.equals(this.parameterName, that.parameterName);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.text, this.isOptional, this.optionalNotMatch, this.parserKeyword, this.parameterName);
    }
}

