/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Function;
import net.apartium.cocoabeans.commands.ArgumentContext;
import net.apartium.cocoabeans.commands.ArgumentConverter;
import net.apartium.cocoabeans.commands.ArgumentIndex;
import net.apartium.cocoabeans.commands.ArgumentMapper;
import net.apartium.cocoabeans.commands.CommandContext;
import net.apartium.cocoabeans.commands.RegisterArgumentParser;
import net.apartium.cocoabeans.commands.RegisteredVariant;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.exception.CommandException;
import net.apartium.cocoabeans.commands.requirements.Requirement;
import net.apartium.cocoabeans.structs.Entry;
import net.apartium.cocoabeans.utils.OptionalFloat;
import org.jetbrains.annotations.ApiStatus;

public class SimpleArgumentMapper
implements ArgumentMapper {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_MAP = Map.ofEntries(Map.entry(Byte.class, Byte.TYPE), Map.entry(Character.class, Character.TYPE), Map.entry(Short.class, Short.TYPE), Map.entry(Integer.class, Integer.TYPE), Map.entry(Long.class, Long.TYPE), Map.entry(Float.class, Float.TYPE), Map.entry(Double.class, Double.TYPE), Map.entry(Byte.TYPE, Byte.class), Map.entry(Character.TYPE, Character.class), Map.entry(Short.TYPE, Short.class), Map.entry(Integer.TYPE, Integer.class), Map.entry(Long.TYPE, Long.class), Map.entry(Float.TYPE, Float.class), Map.entry(Double.TYPE, Double.class));
    private static final Map<Class<?>, Class<?>> OPTIONAL_TO_PRIMITIVE_MAP = Map.of(OptionalInt.class, Integer.TYPE, OptionalLong.class, Long.TYPE, OptionalDouble.class, Double.TYPE, OptionalFloat.class, Float.TYPE);
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_OPTIMAL = Map.of(Integer.TYPE, OptionalInt.class, Long.TYPE, OptionalLong.class, Double.TYPE, OptionalDouble.class, Float.TYPE, OptionalFloat.class, Integer.class, OptionalInt.class, Long.class, OptionalLong.class, Double.class, OptionalDouble.class, Float.class, OptionalFloat.class);
    private static final Map<Class<?>, Object> EMPTY_OPTIONAL = Map.of(Integer.TYPE, OptionalInt.empty(), Integer.class, OptionalInt.empty(), Long.TYPE, OptionalLong.empty(), Long.class, OptionalLong.empty(), Double.TYPE, OptionalDouble.empty(), Double.class, OptionalDouble.empty(), Float.TYPE, OptionalFloat.empty(), Float.class, OptionalFloat.empty());
    private static final Map<Class<?>, Function<Object, Object>> OF_OPTIONAL = Map.of(Optional.class, Optional::of, OptionalInt.class, obj -> {
        if (obj == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of((Integer)obj);
    }, OptionalLong.class, obj -> {
        if (obj == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of((Long)obj);
    }, OptionalDouble.class, obj -> {
        if (obj == null || Double.isNaN((Double)obj)) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of((Double)obj);
    }, OptionalFloat.class, obj -> {
        if (obj == null || Float.isNaN(((Float)obj).floatValue())) {
            return OptionalFloat.empty();
        }
        return OptionalFloat.of(((Float)obj).floatValue());
    });
    protected final List<ArgumentConverter<?>> converters;

    @ApiStatus.AvailableSince(value="0.0.44")
    public SimpleArgumentMapper(List<ArgumentConverter<?>> converters) {
        this.converters = List.copyOf(converters);
    }

    public SimpleArgumentMapper() {
        this(List.of());
    }

    @Override
    public List<ArgumentIndex<?>> mapIndices(RegisteredVariant.Parameter[] parameters, List<RegisterArgumentParser<?>> argumentParsers, List<Requirement> requirements, List<Class<?>> additionalTypes) {
        if (parameters.length == 0) {
            return List.of();
        }
        ArrayList result = new ArrayList(parameters.length);
        HashMap counterMap = new HashMap();
        ResultMap resultMap = this.createParsedArgs(argumentParsers, requirements, additionalTypes, this.getParametersNames(parameters));
        for (RegisteredVariant.Parameter parameter : parameters) {
            ArgumentIndex<Object> argumentIndex;
            Class<?> type = parameter.type();
            boolean optional = false;
            boolean optionalPrimitive = false;
            if (type == Optional.class) {
                optional = true;
                type = this.getGenericType(parameter.parameterizedType());
            } else if (OPTIONAL_TO_PRIMITIVE_MAP.containsKey(type)) {
                type = OPTIONAL_TO_PRIMITIVE_MAP.get(type);
                optionalPrimitive = true;
            }
            int index = counterMap.computeIfAbsent(type, k -> 0);
            try {
                argumentIndex = this.resolveArgumentIndex(type, parameter.parameterName(), counterMap, resultMap, index);
            }
            catch (NoSuchElementException e) {
                throw new NoSuchElementException("There is no argument for parameter " + parameter.parameterName() + " at index " + index + ".", e);
            }
            if (optional) {
                argumentIndex = this.wrapInOptional(argumentIndex);
            }
            if (optionalPrimitive) {
                argumentIndex = this.wrapInOptionalPrimitive(argumentIndex, type);
            }
            result.add(argumentIndex);
            counterMap.put(type, (Integer)counterMap.get(type) + 1);
        }
        return result;
    }

    @ApiStatus.AvailableSince(value="0.0.44")
    protected <T> ArgumentIndex<T> map(ArgumentConverter<T> converter, ArgumentIndex<?> argumentIndex) {
        return context -> {
            Object obj = argumentIndex.get(context);
            if (obj == null) {
                return null;
            }
            return converter.convert(obj);
        };
    }

    private Map<String, Class<?>> getParametersNames(RegisteredVariant.Parameter[] parameters) {
        HashMap result = new HashMap();
        for (RegisteredVariant.Parameter parameter : parameters) {
            if (parameter.parameterName() == null) continue;
            if (result.containsKey(parameter.parameterName())) {
                throw new IllegalArgumentException("Duplicate parameter name " + parameter.parameterName());
            }
            result.put(parameter.parameterName(), parameter.type());
        }
        return result;
    }

    private Class<?> getGenericType(Type parameterizedType) {
        return (Class)((ParameterizedType)parameterizedType).getActualTypeArguments()[0];
    }

    private ArgumentIndex<Optional<?>> wrapInOptional(ArgumentIndex<?> argumentIndex) {
        return context -> {
            Object obj = argumentIndex.get(context);
            if (obj == null) {
                return Optional.empty();
            }
            if (obj instanceof Optional) {
                return (Optional)obj;
            }
            return Optional.of(obj);
        };
    }

    private ArgumentIndex<?> wrapInOptionalPrimitive(ArgumentIndex<?> argumentIndex, Class<?> type) {
        return context -> {
            Object obj = argumentIndex.get(context);
            if (obj instanceof Optional) {
                Optional opt = (Optional)obj;
                obj = opt.orElse(null);
            }
            if (obj == null) {
                return EMPTY_OPTIONAL.get(type);
            }
            return OF_OPTIONAL.get(PRIMITIVE_TO_OPTIMAL.get(type)).apply(obj);
        };
    }

    private ArgumentIndex<?> resolveArgumentIndex(Class<?> type, String name, Map<Class<?>, Integer> counterMap, ResultMap resultMap, int index) {
        if (name != null && resultMap.mapOfArgumentsByParameterName.containsKey(name)) {
            counterMap.put(type, counterMap.get(type) - 1);
            return resultMap.mapOfArgumentsByParameterName.get(name);
        }
        ArgumentIndex<?> argumentIndex = this.resolveBuiltInArgumentIndex(type, counterMap, resultMap.mapOfArgumentsByType, index);
        if (argumentIndex != null) {
            return argumentIndex;
        }
        List<ArgumentIndex<?>> arguments = resultMap.mapOfArgumentsByType.get(type);
        if (this.isInvalidArguments(arguments, index)) {
            arguments = this.findArgumentsByWrapperType(type, resultMap.mapOfArgumentsByType);
        }
        if (this.isInvalidArguments(arguments, index)) {
            arguments = this.findArgumentsByAssignableType(type, resultMap.mapOfArgumentsByType);
        }
        if (this.isInvalidArguments(arguments, index) && (argumentIndex = this.findArgumentsByMapConverters(type, index, resultMap.mapOfArgumentsByType, counterMap)) != null) {
            return argumentIndex;
        }
        if (this.isInvalidArguments(arguments, index)) {
            throw new NoSuchElementException("No argument found for type " + String.valueOf(type) + " at index " + index);
        }
        return arguments.get(index);
    }

    private ArgumentIndex<?> findArgumentsByMapConverters(Class<?> type, int index, Map<Class<?>, List<ArgumentIndex<?>>> mapOfArgumentsByType, Map<Class<?>, Integer> counterMap) {
        for (ArgumentConverter<?> converter : this.converters) {
            if (!type.isAssignableFrom(converter.targetType())) continue;
            List<ArgumentIndex<?>> arguments = null;
            Entry<Class<?>, List<ArgumentIndex<?>>> mapper = this.getMapper(converter, mapOfArgumentsByType, Map.of());
            if (mapper != null) {
                arguments = mapper.value();
                index = counterMap.getOrDefault(mapper.key(), 0);
            }
            if (this.isInvalidArguments(arguments, index) && (mapper = this.getMapper(converter, mapOfArgumentsByType, PRIMITIVE_TO_WRAPPER_MAP)) != null) {
                arguments = mapper.value();
                index = counterMap.getOrDefault(mapper.key(), 0);
            }
            if (mapper == null || this.isInvalidArguments(arguments, index)) continue;
            arguments.set(index, this.map(converter, arguments.get(index)));
            counterMap.put(type, counterMap.getOrDefault(type, 0) - 1);
            counterMap.put(mapper.key(), counterMap.getOrDefault(mapper.key(), 0) + 1);
            return arguments.get(index);
        }
        return null;
    }

    private Entry<Class<?>, List<ArgumentIndex<?>>> getMapper(ArgumentConverter<?> converter, Map<Class<?>, List<ArgumentIndex<?>>> mapOfArgumentsByType, Map<Class<?>, Class<?>> classMapper) {
        for (Map.Entry<Class<?>, List<ArgumentIndex<?>>> entry : mapOfArgumentsByType.entrySet()) {
            Class<?> clazz = entry.getKey();
            if (!converter.isSourceTypeSupported(clazz = classMapper.getOrDefault(clazz, clazz))) continue;
            return new Entry(entry.getKey(), entry.getValue());
        }
        return null;
    }

    private boolean isInvalidArguments(List<ArgumentIndex<?>> arguments, int index) {
        return arguments == null || arguments.size() <= index;
    }

    private List<ArgumentIndex<?>> findArgumentsByWrapperType(Class<?> type, Map<Class<?>, List<ArgumentIndex<?>>> mapOfArguments) {
        return mapOfArguments.get(PRIMITIVE_TO_WRAPPER_MAP.getOrDefault(type, type));
    }

    private List<ArgumentIndex<?>> findArgumentsByAssignableType(Class<?> type, Map<Class<?>, List<ArgumentIndex<?>>> mapOfArguments) {
        return mapOfArguments.entrySet().stream().filter(entry -> type.isAssignableFrom((Class)entry.getKey())).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    protected ArgumentIndex<?> resolveBuiltInArgumentIndex(Class<?> type, Map<Class<?>, Integer> counterMap, Map<Class<?>, List<ArgumentIndex<?>>> mapOfArguments, int index) {
        for (ArgumentConverter<Object> argumentConverter : this.converters) {
            if (!type.isAssignableFrom(argumentConverter.targetType())) continue;
            if (argumentConverter.isSourceTypeSupported(Sender.class)) {
                return this.map(argumentConverter, this.getSenderIndex(mapOfArguments, index));
            }
            if (!argumentConverter.isSourceTypeSupported(CommandContext.class)) continue;
            if (index != 0) {
                throw new IllegalArgumentException("Can't use index " + index + " for CommandContext");
            }
            return this.map(argumentConverter, context -> context.parsedArgs().get(CommandContext.class).get(0));
        }
        if (Sender.class.isAssignableFrom(type)) {
            return this.getSenderIndex(mapOfArguments, index);
        }
        if (CommandContext.class.equals(type)) {
            if (index != 0) {
                throw new IllegalArgumentException("Can't use index " + index + " for CommandContext");
            }
            return context -> context.parsedArgs().get(CommandContext.class).get(0);
        }
        return null;
    }

    private ArgumentIndex<?> getSenderIndex(Map<Class<?>, List<ArgumentIndex<?>>> mapOfArguments, int index) {
        if (index == 0) {
            return ArgumentContext::sender;
        }
        return mapOfArguments.get(Sender.class).get(index - 1);
    }

    private ResultMap createParsedArgs(List<RegisterArgumentParser<?>> argumentParsers, List<Requirement> requirements, List<Class<?>> additionalTypes, Map<String, Class<?>> lookupParametersNames) {
        HashMap resultMap = new HashMap();
        HashMap resultParameterName = new HashMap();
        HashMap counterMap = new HashMap();
        this.checkDuplicateArgumentParsersName(argumentParsers);
        for (RegisterArgumentParser<?> registerArgumentParser : argumentParsers) {
            this.serializesArgumentIndex(registerArgumentParser.getArgumentType(), registerArgumentParser.getParameterName().orElse(null), lookupParametersNames, counterMap, resultMap, resultParameterName);
        }
        for (Requirement requirement : requirements) {
            for (Class<?> type : requirement.getTypes()) {
                this.serializesArgumentIndex(type, null, lookupParametersNames, counterMap, resultMap, resultParameterName);
            }
        }
        for (Class clazz : additionalTypes) {
            this.serializesArgumentIndex(clazz, null, lookupParametersNames, counterMap, resultMap, resultParameterName);
        }
        return new ResultMap(resultMap, resultParameterName);
    }

    private void checkDuplicateArgumentParsersName(List<RegisterArgumentParser<?>> argumentParsers) {
        HashSet<String> visitedNames = new HashSet<String>();
        for (RegisterArgumentParser<?> argumentParser : argumentParsers) {
            String name = argumentParser.getParameterName().orElse(null);
            if (name == null || visitedNames.add(name)) continue;
            throw new IllegalArgumentException("Duplicate parameter name " + name);
        }
    }

    private void serializesArgumentIndex(Class<?> type, String parameterName, Map<String, Class<?>> lookupParametersNames, Map<Class<?>, Integer> counterMap, Map<Class<?>, List<ArgumentIndex<?>>> resultMap, Map<String, ArgumentIndex<?>> resultParameterName) {
        int countIndex = counterMap.getOrDefault(type, 0);
        counterMap.put(type, countIndex + 1);
        if (parameterName != null && lookupParametersNames.containsKey(parameterName)) {
            Class<?> targetType = lookupParametersNames.get(parameterName);
            if (!targetType.isAssignableFrom(type)) {
                for (ArgumentConverter<?> converter : this.converters) {
                    if (!targetType.isAssignableFrom(converter.targetType()) || !converter.isSourceTypeSupported(type)) continue;
                    resultParameterName.put(parameterName, this.map(converter, context -> context.parsedArgs().get(type).get(countIndex)));
                    return;
                }
                throw new IllegalArgumentException("Parameter name " + parameterName + " is not assignable from type " + String.valueOf(type));
            }
            resultParameterName.put(parameterName, context -> context.parsedArgs().get(type).get(countIndex));
            return;
        }
        if (CommandException.class.isAssignableFrom(type)) {
            resultMap.computeIfAbsent(type, k -> new ArrayList()).add(context -> {
                for (Map.Entry<Class<?>, List<Object>> entry : context.parsedArgs().entrySet()) {
                    if (!type.isAssignableFrom(entry.getKey())) continue;
                    return entry.getValue().get(0);
                }
                return null;
            });
            return;
        }
        resultMap.computeIfAbsent(type, k -> new ArrayList()).add(context -> context.parsedArgs().get(type).get(countIndex));
    }

    @ApiStatus.AvailableSince(value="0.0.37")
    public record ResultMap(Map<Class<?>, List<ArgumentIndex<?>>> mapOfArgumentsByType, Map<String, ArgumentIndex<?>> mapOfArgumentsByParameterName) {
    }
}

