/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.apartium.cocoabeans.commands.ArgumentIndex;
import net.apartium.cocoabeans.commands.GenericNode;
import net.apartium.cocoabeans.commands.Param;
import net.apartium.cocoabeans.commands.requirements.ArgumentRequirement;
import net.apartium.cocoabeans.commands.requirements.ArgumentRequirementFactory;
import org.jetbrains.annotations.ApiStatus;

public record RegisteredVariant(MethodHandle method, Parameter[] parameters, GenericNode node, List<ArgumentIndex<?>> argumentIndexList, int priority) {
    public static final Comparator<RegisteredVariant> REGISTERED_VARIANT_COMPARATOR = (a, b) -> Integer.compare(b.priority(), a.priority());

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof RegisteredVariant)) {
            return false;
        }
        RegisteredVariant that = (RegisteredVariant)o;
        return this.priority == that.priority && Objects.equals(this.node, that.node) && Objects.equals(this.method, that.method) && Objects.deepEquals(this.parameters, that.parameters) && Objects.equals(this.argumentIndexList, that.argumentIndexList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.method, Arrays.hashCode(this.parameters), this.node, this.argumentIndexList, this.priority);
    }

    @Override
    public String toString() {
        return "RegisteredVariant{method=" + String.valueOf(this.method) + ", parameters=" + Arrays.toString(this.parameters) + ", node=" + String.valueOf(this.node) + ", argumentIndexList=" + String.valueOf(this.argumentIndexList) + ", priority=" + this.priority + "}";
    }

    public record Parameter(Class<?> type, Type parameterizedType, ArgumentRequirement[] argumentRequirements, String parameterName) {
        @ApiStatus.AvailableSince(value="0.0.37")
        public static Parameter[] of(GenericNode node, java.lang.reflect.Parameter[] parameters, Map<Class<? extends ArgumentRequirementFactory>, ArgumentRequirementFactory> argumentRequirementFactories) {
            Parameter[] result = new Parameter[parameters.length];
            for (int i = 0; i < result.length; ++i) {
                Type parameterizedType = parameters[i].getParameterizedType();
                Type genericSuperclass = parameters[i].getType().getGenericSuperclass();
                if (genericSuperclass instanceof ParameterizedType) {
                    parameterizedType = genericSuperclass;
                }
                result[i] = new Parameter(parameters[i].getType(), parameterizedType, ArgumentRequirementFactory.createArgumentRequirements(node, parameters[i].getAnnotations(), argumentRequirementFactories), Parameter.getParamName(parameters[i]));
            }
            return result;
        }

        @ApiStatus.Internal
        private static String getParamName(java.lang.reflect.Parameter parameter) {
            String name = Optional.ofNullable(parameter.getAnnotation(Param.class)).map(Param::value).orElse(null);
            if (name == null) {
                return null;
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Parameter name cannot be empty");
            }
            return name;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            return Objects.equals(this.type, parameter.type) && Objects.equals(this.parameterName, parameter.parameterName) && Objects.equals(this.parameterizedType, parameter.parameterizedType) && Objects.deepEquals(this.argumentRequirements, parameter.argumentRequirements);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.type, this.parameterizedType, Arrays.hashCode(this.argumentRequirements), this.parameterName);
        }

        @Override
        public String toString() {
            return "Parameter{type=" + String.valueOf(this.type) + ", parameterizedType=" + String.valueOf(this.parameterizedType) + ", argumentRequirements=" + Arrays.toString(this.argumentRequirements) + ", parameterName='" + this.parameterName + "'}";
        }
    }
}

