/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.apartium.cocoabeans.collect.WeightSet;
import org.jetbrains.annotations.ApiStatus;

public class CollectionHelpers {
    public static <E> E randomEntry(Collection<E> collection, Random random) {
        if (collection instanceof WeightSet) {
            WeightSet weightSet = (WeightSet)collection;
            return weightSet.pickOne(random);
        }
        if (collection.isEmpty()) {
            return null;
        }
        int index = random.nextInt(collection.size());
        return CollectionHelpers.pickEntry(collection, index);
    }

    public static <E> E pickEntry(Collection<E> collection, int index) {
        if (collection instanceof List) {
            List list = (List)collection;
            return list.get(index);
        }
        if (collection.size() < index + 1) {
            throw new IndexOutOfBoundsException(String.format("Index %d out of bound for size %d", index, collection.size()));
        }
        for (E e : collection) {
            if (index == 0) {
                return e;
            }
            --index;
        }
        return null;
    }

    public static boolean containsStartsWith(Collection<String> collection, String value, String appendToElement) {
        if (appendToElement == null) {
            appendToElement = "";
        }
        if (collection == null || value == null) {
            return false;
        }
        for (String string : collection) {
            if (!value.startsWith(appendToElement + string)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsArray(Object[] arr0, Object[] arr1) {
        return CollectionHelpers.equalsList(List.of(arr0), List.of(arr1));
    }

    public static boolean equalsList(List<?> list0, List<?> list1) {
        if (list0 == list1) {
            return true;
        }
        if (list0.size() != list1.size()) {
            return false;
        }
        if (list0.isEmpty()) {
            return true;
        }
        List<Integer> leftIndex = CollectionHelpers.range(0, list0.size(), 1);
        block0: for (Object object : list0) {
            Iterator<Integer> iterator = leftIndex.iterator();
            while (iterator.hasNext()) {
                int index = iterator.next();
                if (!object.equals(list1.get(index))) continue;
                iterator.remove();
                continue block0;
            }
            return false;
        }
        return leftIndex.isEmpty();
    }

    @ApiStatus.AvailableSince(value="0.0.39")
    public static boolean equalsCollections(Collection<?> a, Collection<?> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int size = a.size();
        if (size != b.size()) {
            return false;
        }
        Iterator<?> iterator = a.iterator();
        Iterator<?> iterator1 = b.iterator();
        int i = 0;
        while (iterator.hasNext() && iterator1.hasNext()) {
            Object next1;
            if (i++ > size) {
                return false;
            }
            Object next = iterator.next();
            if (Objects.equals(next, next1 = iterator1.next())) continue;
            return false;
        }
        return !iterator.hasNext() && !iterator1.hasNext();
    }

    public static List<Integer> range(int start, int end, int step) {
        boolean startBigger;
        if (step == 0) {
            throw new IllegalArgumentException("Step cannot be zero");
        }
        if (step < 0) {
            throw new IllegalArgumentException("Step must be positive");
        }
        boolean bl = startBigger = start > end;
        if (startBigger) {
            step = -step;
        }
        ArrayList<Integer> result = new ArrayList<Integer>(Math.abs(end - start) / step);
        int i = start;
        while (startBigger ? i > end : i < end) {
            result.add(i);
            i += step;
        }
        return result;
    }

    public static <E> void addElementSorted(List<E> list, E element, Comparator<E> comparator) {
        int index = Collections.binarySearch(list, element, comparator);
        if (index < 0) {
            index = -index - 1;
        }
        list.add(index, element);
    }

    @ApiStatus.AvailableSince(value="0.0.37")
    public static <K, V> void mergeInto(Map<K, V> map, Map<K, V> other) {
        for (Map.Entry<K, V> entry : other.entrySet()) {
            map.putIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    @ApiStatus.AvailableSince(value="0.0.39")
    public static <T> boolean isSorted(List<T> list, Comparator<? super T> comparator) {
        if (list.isEmpty() || list.size() == 1) {
            return true;
        }
        for (int i = 0; i < list.size() - 1; ++i) {
            if (comparator.compare(list.get(i), list.get(i + 1)) <= 0) continue;
            return false;
        }
        return true;
    }
}

