/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.utils;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.apartium.cocoabeans.functions.FloatConsumer;
import net.apartium.cocoabeans.functions.FloatPredicate;
import net.apartium.cocoabeans.functions.FloatSupplier;
import net.apartium.cocoabeans.functions.FloatToObject;

public final class OptionalFloat {
    private static final OptionalFloat EMPTY = new OptionalFloat(0.0f);
    final float value;

    public static OptionalFloat empty() {
        return EMPTY;
    }

    public static OptionalFloat of(float val) {
        return new OptionalFloat(val);
    }

    private OptionalFloat(float value) {
        this.value = value;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public float getAsFloat() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public void ifPresent(FloatConsumer consumer) {
        if (!this.isEmpty()) {
            consumer.accept(this.value);
        }
    }

    public float getOrThrow(Supplier<RuntimeException> exceptionSupplier) {
        if (this.isEmpty()) {
            throw exceptionSupplier.get();
        }
        return this.value;
    }

    public OptionalFloat filter(FloatPredicate predicate) {
        if (this.isEmpty()) {
            return this;
        }
        return predicate.test(this.value) ? this : OptionalFloat.empty();
    }

    public <E> Optional<E> mapToObj(FloatToObject<E> operation) {
        return this.isEmpty() ? Optional.empty() : Optional.ofNullable(operation.map(this.value));
    }

    public float orElse(float f) {
        return this.isEmpty() ? f : this.value;
    }

    public float orElseGet(FloatSupplier supplier) {
        return this.isEmpty() ? supplier.getAsFloat() : this.value;
    }

    public boolean isPresent() {
        return !this.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionalFloat that = (OptionalFloat)o;
        return Float.compare(that.value, this.value) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.value));
    }

    public String toString() {
        return !this.isEmpty() ? String.format("Optional[%s]", Float.valueOf(this.value)) : "Optional.empty";
    }
}

