/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.spigot.lazies;

import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.util.Locale;
import net.apartium.cocoabeans.Dispensers;
import net.apartium.cocoabeans.Ensures;
import net.apartium.cocoabeans.commands.CommandManager;
import net.apartium.cocoabeans.commands.CommandNode;
import net.apartium.cocoabeans.spigot.Commands;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandAutoRegistration {
    private static Class<?> COMMAND_NODE_CLASS;
    private final JavaPlugin plugin;
    boolean allowDirectCommandMapRegistration;
    boolean loadDevCommands;
    CommandManager commandManager;

    public CommandAutoRegistration(JavaPlugin plugin) {
        try {
            COMMAND_NODE_CLASS = Class.forName("net.apartium.cocoabeans.commands.CommandNode");
        }
        catch (ClassNotFoundException e) {
            COMMAND_NODE_CLASS = null;
        }
        Ensures.notNull((Object)plugin, "plugin +-");
        this.plugin = plugin;
    }

    public CommandAutoRegistration enableDevCommands(boolean value) {
        this.loadDevCommands = value;
        return this;
    }

    public CommandAutoRegistration setCommandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public CommandAutoRegistration iAmALazyAssDeveloper() {
        this.allowDirectCommandMapRegistration = true;
        return this;
    }

    public void register(String packageName) {
        this.register(packageName, true);
    }

    public void register(String packageName, boolean deep) {
        ClassPath classPath;
        Ensures.notEmpty(packageName, "plugin +-");
        ClassLoader classLoader = this.plugin.getClass().getClassLoader();
        try {
            classPath = ClassPath.from((ClassLoader)classLoader);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        for (ClassPath.ClassInfo classInfo : deep ? classPath.getTopLevelClassesRecursive(packageName) : classPath.getTopLevelClasses(packageName)) {
            boolean devCommand;
            Command annotation;
            Class<?> clazz;
            try {
                clazz = classLoader.loadClass(classInfo.getName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            if (COMMAND_NODE_CLASS != null && COMMAND_NODE_CLASS.isAssignableFrom(clazz)) {
                this.handleCommandNode(clazz);
                continue;
            }
            if (!CommandExecutor.class.isAssignableFrom(clazz) || (annotation = clazz.getAnnotation(Command.class)) == null || (devCommand = annotation.devServer()) && !this.loadDevCommands) continue;
            final CommandExecutor instance = (CommandExecutor)this.createInstance(clazz);
            PluginCommand pluginCommand = this.plugin.getCommand(annotation.value());
            if (pluginCommand == null) {
                if (this.allowDirectCommandMapRegistration) {
                    Commands.getCommandMap().register(annotation.value(), this.plugin.getName().toLowerCase(Locale.ROOT), new org.bukkit.command.Command(annotation.value()){

                        public boolean execute(CommandSender sender, String commandLabel, String[] args) {
                            return instance.onCommand(sender, (org.bukkit.command.Command)this, commandLabel, args);
                        }
                    });
                    continue;
                }
                this.plugin.getLogger().warning("Command /" + annotation.value() + " is not registered to this plugin!");
                continue;
            }
            pluginCommand.setExecutor(instance);
            this.plugin.getLogger().info("Loaded " + (devCommand ? "dev" : "") + " command /" + annotation.value() + "!");
        }
    }

    private void handleCommandNode(Class<?> clazz) {
        if (clazz.getAnnotation(net.apartium.cocoabeans.commands.Command.class) == null) {
            this.plugin.getLogger().warning("Command class " + clazz.getName() + " is not annotated with @Command!");
            return;
        }
        Command annotation = clazz.getAnnotation(Command.class);
        if (annotation != null && annotation.devServer() && !this.loadDevCommands) {
            this.plugin.getLogger().warning(clazz.getName() + " wasn't registered to this plugin because it's a dev command!");
            return;
        }
        CommandNode node = (CommandNode)this.createInstance(clazz);
        this.commandManager.addCommand(node);
    }

    private Object createInstance(Class<?> clazz) {
        Constructor<?> constructor = clazz.getConstructors()[0];
        try {
            Object[] objectArray;
            if (constructor.getParameterCount() == 0) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.plugin;
            }
            return constructor.newInstance(objectArray);
        }
        catch (Exception e) {
            Dispensers.dispense(e);
            return null;
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Command {
        public String value();

        public boolean devServer() default false;
    }
}

