/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.space;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import net.apartium.cocoabeans.space.Position;
import net.apartium.cocoabeans.space.Rotation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.30")
public class Transform {
    private Position position;
    private Rotation rotation;

    @JsonCreator
    public Transform(@JsonProperty(value="x") double x, @JsonProperty(value="y") double y, @JsonProperty(value="z") double z, @JsonProperty(value="yaw") float yaw, @JsonProperty(value="pitch") float pitch) {
        this.position = new Position(x, y, z);
        this.rotation = new Rotation(yaw, pitch);
    }

    public Transform(Position position, Rotation rotation) {
        this.position = position;
        this.rotation = rotation;
    }

    public Transform(Transform other) {
        this.position = new Position(other.position);
        this.rotation = new Rotation(other.rotation);
    }

    public double getX() {
        return this.position.getX();
    }

    public Transform setX(double x) {
        this.position.setX(x);
        return this;
    }

    public double getY() {
        return this.position.getY();
    }

    public Transform setY(double y) {
        this.position.setY(y);
        return this;
    }

    public double getZ() {
        return this.position.getZ();
    }

    public Transform setZ(double z) {
        this.position.setZ(z);
        return this;
    }

    public float getYaw() {
        return this.rotation.getYaw();
    }

    public Transform setYaw(float yaw) {
        this.rotation.setYaw(yaw);
        return this;
    }

    public float getPitch() {
        return this.rotation.getPitch();
    }

    public Transform setPitch(float pitch) {
        this.rotation.setPitch(pitch);
        return this;
    }

    @JsonIgnore
    public Position getPosition() {
        return this.position;
    }

    public Transform setPosition(Position position) {
        this.position = position;
        return this;
    }

    @JsonIgnore
    public Rotation getRotation() {
        return this.rotation;
    }

    public Transform setRotation(Rotation rotation) {
        this.rotation = rotation;
        return this;
    }

    public Transform translate(Position translation) {
        this.position.add(translation);
        return this;
    }

    public Transform rotate(Rotation deltaRotation) {
        this.rotation.add(deltaRotation);
        return this;
    }

    @JsonIgnore
    public Position getDirectionVector() {
        return Position.fromDirection(this.rotation.getYaw(), this.rotation.getPitch());
    }

    public String toString() {
        return "Transform(position=" + this.position + ", rotation=" + this.rotation + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transform transform = (Transform)o;
        return Objects.equals(this.position, transform.position) && Objects.equals(this.rotation, transform.rotation);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.rotation);
    }
}

