/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.space;

import net.apartium.cocoabeans.space.Position;
import net.apartium.cocoabeans.space.Region;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.22")
public class SphereRegion
implements Region {
    private Position center;
    private double radius;
    private double radiusSquared;

    public SphereRegion(Position center, double radius) {
        this.center = center;
        this.radius = radius;
        this.radiusSquared = radius * radius;
    }

    @Override
    public boolean contains(Position position) {
        return position.distanceSquared(this.center) <= this.radiusSquared;
    }

    @Override
    public double distance(Position position) {
        double distance = position.distance(this.center) - this.radius;
        if (distance < 0.0) {
            return 0.0;
        }
        return distance;
    }

    public Position getCenter() {
        return this.center.copy();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setCenter(Position center) {
        this.center = center.copy();
    }

    public void setRadius(double radius) {
        this.radius = radius;
        this.radiusSquared = radius * radius;
    }
}

