/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.security.totp;

import net.apartium.cocoabeans.security.totp.CodeGenerator;
import net.apartium.cocoabeans.security.totp.CodeVerifier;
import net.apartium.cocoabeans.utils.TimeProvider;

class CodeVerifierImpl
implements CodeVerifier {
    private final CodeGenerator codeGenerator;
    private final TimeProvider timeProvider;
    private final int timePeriod;
    private final int allowedTimePeriodDiscrepancy;

    CodeVerifierImpl(CodeGenerator codeGenerator, TimeProvider timeProvider) {
        this(codeGenerator, timeProvider, 30, 1);
    }

    CodeVerifierImpl(CodeGenerator codeGenerator, TimeProvider timeProvider, int timePeriod, int allowedTimePeriodDiscrepancy) {
        this.codeGenerator = codeGenerator;
        this.timeProvider = timeProvider;
        this.timePeriod = timePeriod;
        this.allowedTimePeriodDiscrepancy = allowedTimePeriodDiscrepancy;
    }

    @Override
    public boolean isValidCode(String secret, String attemptCode) {
        long currentBucket = Math.floorDiv(this.timeProvider.getTime(), this.timePeriod);
        boolean found = false;
        for (int i = -this.allowedTimePeriodDiscrepancy; i <= this.allowedTimePeriodDiscrepancy; ++i) {
            found = this.checkCode(secret, attemptCode, currentBucket + (long)i) || found;
        }
        return found;
    }

    private boolean checkCode(String secret, String attemptCode, long counter) {
        try {
            return this.equal(this.codeGenerator.generate(secret, counter), attemptCode);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean equal(String a, String b) {
        byte[] bBytes;
        if (a == null || b == null) {
            return false;
        }
        byte[] aBytes = a.getBytes();
        if (aBytes.length != (bBytes = b.getBytes()).length) {
            return false;
        }
        int result = 0;
        for (int i = 0; i < aBytes.length; ++i) {
            result |= aBytes[i] ^ bBytes[i];
        }
        return result == 0;
    }
}

