/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.security.totp;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.apartium.cocoabeans.encode.BaseConverter;
import net.apartium.cocoabeans.security.HashingAlgorithm;
import net.apartium.cocoabeans.security.totp.CodeGenerator;

class CodeGeneratorImpl
implements CodeGenerator {
    private final HashingAlgorithm algorithm;
    private final int digits;

    CodeGeneratorImpl() {
        this(HashingAlgorithm.SHA1, 6);
    }

    CodeGeneratorImpl(HashingAlgorithm algorithm, int digits) throws InvalidParameterException {
        if (algorithm == null) {
            throw new InvalidParameterException("HashingAlgorithm must not be null.");
        }
        if (digits < 1) {
            throw new InvalidParameterException("Number of digits must be larger than 0.");
        }
        this.algorithm = algorithm;
        this.digits = digits;
    }

    @Override
    public String generate(String secret, long counter) throws Exception {
        byte[] hash = this.generateHash(secret, counter);
        return this.getDigitsFromHash(hash);
    }

    private byte[] generateHash(String secret, long counter) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] data = new byte[8];
        long value = counter;
        int i = 8;
        while (i-- > 0) {
            data[i] = (byte)value;
            value >>>= 8;
        }
        byte[] decodedKey = BaseConverter.base32().decode(secret);
        SecretKeySpec signKey = new SecretKeySpec(decodedKey, this.algorithm.getHmacAlgorithm());
        Mac mac = Mac.getInstance(this.algorithm.getHmacAlgorithm());
        mac.init(signKey);
        return mac.doFinal(data);
    }

    private String getDigitsFromHash(byte[] hash) {
        int offset = hash[hash.length - 1] & 0xF;
        long truncatedHash = 0L;
        for (int i = 0; i < 4; ++i) {
            truncatedHash <<= 8;
            truncatedHash |= (long)(hash[offset + i] & 0xFF);
        }
        truncatedHash &= Integer.MAX_VALUE;
        return String.format("%0" + this.digits + "d", truncatedHash %= (long)Math.pow(10.0, this.digits));
    }
}

