/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.reflect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.apartium.cocoabeans.reflect.ReflectionCache;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodUtils {
    public static Set<Method> getDeclaredMethods(Class<?> clazz) {
        return ReflectionCache.getDeclaredMethods(clazz).collect(Collectors.toSet());
    }

    public static Set<Method> getMethods(Class<?> clazz) {
        return ReflectionCache.getMethods(clazz).collect(Collectors.toSet());
    }

    @ApiStatus.AvailableSince(value="0.0.29")
    public static Set<Method> getMethodsFromSuperClassAndInterface(Method method) {
        if (method == null) {
            return Collections.emptySet();
        }
        Class<?> clazz = method.getDeclaringClass();
        if (clazz == Object.class) {
            return Collections.emptySet();
        }
        HashSet<Method> result = new HashSet<Method>();
        Method superClassMethod = MethodUtils.getSuperClassMethod(method);
        if (superClassMethod != null) {
            result.add(superClassMethod);
            result.addAll(MethodUtils.getMethodsFromSuperClassAndInterface(superClassMethod));
        }
        for (Method interfacesMethod : MethodUtils.getInterfacesMethods(method)) {
            result.add(interfacesMethod);
            result.addAll(MethodUtils.getMethodsFromSuperClassAndInterface(interfacesMethod));
        }
        return result;
    }

    @ApiStatus.AvailableSince(value="0.0.29")
    @Nullable
    public static Method getSuperClassMethod(@NotNull Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if (clazz.getSuperclass() == null) {
            return null;
        }
        return ReflectionCache.getMethod(clazz.getSuperclass(), method.getName(), method.getParameterTypes());
    }

    @ApiStatus.AvailableSince(value="0.0.29")
    public static Method[] getInterfacesMethods(@NotNull Method method) {
        Class<?>[] interfaces = method.getDeclaringClass().getInterfaces();
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Class<?> anInterface : interfaces) {
            Method declaredMethod = ReflectionCache.getMethod(anInterface, method.getName(), method.getParameterTypes());
            if (declaredMethod == null) continue;
            methods.add(declaredMethod);
        }
        return methods.toArray(new Method[0]);
    }

    @ApiStatus.AvailableSince(value="0.0.29")
    @Nullable
    public static Method getInterfaceMethod(@NotNull Method method, Class<?> interfaceClass) {
        return ReflectionCache.getDeclaredMethod(interfaceClass, method.getName(), method.getParameterTypes());
    }
}

