/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.spigot.requirements.factory;

import net.apartium.cocoabeans.commands.CommandNode;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.requirements.Requirement;
import net.apartium.cocoabeans.commands.requirements.RequirementEvaluationContext;
import net.apartium.cocoabeans.commands.requirements.RequirementFactory;
import net.apartium.cocoabeans.commands.requirements.RequirementResult;
import net.apartium.cocoabeans.commands.requirements.UnmetRequirementResponse;
import net.apartium.cocoabeans.commands.spigot.exception.PermissionException;
import net.apartium.cocoabeans.commands.spigot.requirements.Permission;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Nullable;

public class PermissionFactory
implements RequirementFactory {
    @Override
    @Nullable
    public Requirement getRequirement(CommandNode node, Object obj) {
        if (!(obj instanceof Permission)) {
            return null;
        }
        Permission permission = (Permission)obj;
        return new PermissionImpl(permission, permission.value(), permission.invert());
    }

    private record PermissionImpl(Permission permission, String permissionAsString, boolean invert) implements Requirement
    {
        @Override
        public RequirementResult meetsRequirement(RequirementEvaluationContext context) {
            Object object;
            Sender sender = context.sender();
            if (sender == null || !((object = sender.getSender()) instanceof CommandSender)) {
                return RequirementResult.error(new UnmetPermissionResponse(this, context, "You don't have permission to execute this command"));
            }
            CommandSender commandSender = (CommandSender)object;
            if (!commandSender.hasPermission(this.permissionAsString)) {
                return RequirementResult.error(new UnmetPermissionResponse(this, context, "You don't have permission to execute this command"));
            }
            return RequirementResult.meet();
        }

        private class UnmetPermissionResponse
        extends UnmetRequirementResponse {
            public UnmetPermissionResponse(Requirement requirement, RequirementEvaluationContext context, String message) {
                super(requirement, context, message, PermissionImpl.this.permission);
            }

            @Override
            public Exception getError() {
                return new PermissionException((UnmetRequirementResponse)this, PermissionImpl.this.permission);
            }
        }
    }
}

