/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.spigot.parsers;

import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;

public class PlayerParser
extends ArgumentParser<Player> {
    public static final String DEFAULT_KEYWORD = "player";

    @ApiStatus.AvailableSince(value="0.0.36")
    public PlayerParser(int priority, String keyword) {
        super(keyword, Player.class, priority);
    }

    public PlayerParser(int priority) {
        this(priority, DEFAULT_KEYWORD);
    }

    @Override
    public Optional<ArgumentParser.ParseResult<Player>> parse(CommandProcessingContext processingContext) {
        Player sender;
        int startIndex;
        List<String> args = processingContext.args();
        Player player = Bukkit.getPlayerExact((String)args.get(startIndex = processingContext.index()));
        if (player == null) {
            return Optional.empty();
        }
        Object object = processingContext.sender();
        if (object instanceof Player && !(sender = (Player)object).canSee(player)) {
            return Optional.empty();
        }
        if (processingContext.sender().getSender() != null && (object = processingContext.sender().getSender()) instanceof Player && !(sender = (Player)object).canSee(player)) {
            return Optional.empty();
        }
        return Optional.of(new ArgumentParser.ParseResult<Player>(player, startIndex + 1));
    }

    @Override
    public OptionalInt tryParse(CommandProcessingContext processingContext) {
        return this.parse(processingContext).map(ArgumentParser.ParseResult::newIndex).map(OptionalInt::of).orElse(OptionalInt.empty());
    }

    @Override
    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
        List<String> args = processingContext.args();
        int startIndex = processingContext.index();
        Stream<Object> stream = Bukkit.getOnlinePlayers().stream();
        Sender sender = processingContext.sender();
        if (sender instanceof Player) {
            Player sender2 = (Player)sender;
            stream = stream.filter(arg_0 -> ((Player)sender2).canSee(arg_0));
        }
        return Optional.of(new ArgumentParser.TabCompletionResult(stream.map(Player::getName).filter(s -> s.toLowerCase().startsWith(((String)args.get(startIndex)).toLowerCase())).collect(Collectors.toSet()), startIndex + 1));
    }
}

