/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.spigot.parsers;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import org.bukkit.Material;
import org.jetbrains.annotations.ApiStatus;

public class MaterialParser
extends ArgumentParser<Material> {
    public static final String DEFAULT_KEYWORD = "material";

    @ApiStatus.AvailableSince(value="0.0.36")
    public MaterialParser(int priority, String keyword) {
        super(keyword, Material.class, priority);
    }

    public MaterialParser(int priority) {
        this(priority, DEFAULT_KEYWORD);
    }

    @Override
    public Optional<ArgumentParser.ParseResult<Material>> parse(CommandProcessingContext processingContext) {
        int startIndex;
        List<String> args = processingContext.args();
        Material material = Material.getMaterial((String)args.get(startIndex = processingContext.index()));
        if (material == null) {
            return Optional.empty();
        }
        return Optional.of(new ArgumentParser.ParseResult<Material>(material, startIndex + 1));
    }

    @Override
    public OptionalInt tryParse(CommandProcessingContext processingContext) {
        int startIndex;
        List<String> args = processingContext.args();
        if (Material.getMaterial((String)args.get(startIndex = processingContext.index())) == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(startIndex + 1);
    }

    @Override
    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
        List<String> args = processingContext.args();
        int startIndex = processingContext.index();
        Set result = Arrays.stream(Material.values()).map(type -> {
            if (type.isLegacy()) {
                return type.name();
            }
            return type.getKey().asString();
        }).collect(Collectors.toSet());
        return Optional.of(new ArgumentParser.TabCompletionResult(Arrays.stream(Material.values()).map(Enum::name).filter(s -> s.toLowerCase().startsWith(((String)args.get(startIndex)).toLowerCase())).collect(Collectors.toSet()), startIndex + 1));
    }
}

