/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.spigot.parsers;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import net.apartium.cocoabeans.StringHelpers;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.utils.OptionalFloat;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.ApiStatus;

public class LocationParser
extends ArgumentParser<Location> {
    public static final String DEFAULT_KEYWORD = "location";

    @ApiStatus.AvailableSince(value="0.0.36")
    public LocationParser(int priority, String keyword) {
        super(keyword, Location.class, priority);
    }

    public LocationParser(int priority) {
        this(priority, DEFAULT_KEYWORD);
    }

    @Override
    public Optional<ArgumentParser.ParseResult<Location>> parse(CommandProcessingContext processingContext) {
        List<String> args = processingContext.args();
        int index = processingContext.index();
        int leftArgs = args.size() - index;
        if (leftArgs < 3) {
            return Optional.empty();
        }
        World world = this.getSenderWorld(processingContext).orElse(null);
        OptionalDouble optionalX = StringHelpers.parseDouble(args.get(index));
        if (optionalX.isEmpty()) {
            if (leftArgs < 4) {
                return Optional.empty();
            }
            world = Bukkit.getWorld((String)args.get(index++));
            optionalX = StringHelpers.parseDouble(args.get(index));
        }
        int n = ++index;
        OptionalDouble optionalY = StringHelpers.parseDouble(args.get(n));
        int n2 = ++index;
        ++index;
        OptionalDouble optionalZ = StringHelpers.parseDouble(args.get(n2));
        if (world == null || optionalX.isEmpty() || optionalY.isEmpty() || optionalZ.isEmpty()) {
            return Optional.empty();
        }
        Location location = new Location(world, optionalX.getAsDouble(), optionalY.getAsDouble(), optionalZ.getAsDouble());
        if (args.size() - index < 2) {
            return Optional.of(new ArgumentParser.ParseResult<Location>(location, index));
        }
        OptionalFloat optionalYaw = StringHelpers.parseFloat(args.get(index++));
        OptionalFloat optionalPitch = StringHelpers.parseFloat(args.get(index));
        if (optionalYaw.isEmpty() || optionalPitch.isEmpty()) {
            return Optional.of(new ArgumentParser.ParseResult<Location>(location, index - 1));
        }
        location.setYaw(optionalYaw.getAsFloat());
        location.setPitch(optionalPitch.getAsFloat());
        return Optional.of(new ArgumentParser.ParseResult<Location>(location, index + 1));
    }

    private Optional<World> getSenderWorld(CommandProcessingContext processingContext) {
        Object object = processingContext.sender().getSender();
        if (object instanceof BlockCommandSender) {
            BlockCommandSender console = (BlockCommandSender)object;
            return Optional.of(console.getBlock().getWorld());
        }
        object = processingContext.sender().getSender();
        if (object instanceof Entity) {
            Entity entity = (Entity)object;
            return Optional.of(entity.getWorld());
        }
        return Optional.empty();
    }

    @Override
    public OptionalInt tryParse(CommandProcessingContext processingContext) {
        List<String> args = processingContext.args();
        int index = processingContext.index();
        if (args.size() - index < 4) {
            return OptionalInt.empty();
        }
        if (StringHelpers.parseDouble(args.get(index + 1)).isEmpty() || StringHelpers.parseDouble(args.get(index + 2)).isEmpty() || StringHelpers.parseDouble(args.get(index + 3)).isEmpty()) {
            return OptionalInt.empty();
        }
        if (Bukkit.getWorld((String)args.get(index)) == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(index + 4);
    }

    @Override
    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
        List<String> args = processingContext.args();
        int index = processingContext.index();
        if (args.isEmpty()) {
            return Optional.of(new ArgumentParser.TabCompletionResult(Bukkit.getWorlds().stream().map(WorldInfo::getName).collect(Collectors.toSet()), index + 1));
        }
        if (args.size() - index == 0) {
            return Optional.of(new ArgumentParser.TabCompletionResult(Bukkit.getWorlds().stream().map(WorldInfo::getName).filter(worldName -> ((String)args.get(index)).startsWith((String)worldName)).collect(Collectors.toSet()), index + 1));
        }
        if (args.size() - index == 1 && Bukkit.getWorld((String)args.get(index)) == null) {
            return Optional.empty();
        }
        if (args.size() - index == 2) {
            return this.tabDouble(args.get(index + 1), index + 2);
        }
        if (args.size() - index == 3) {
            if (StringHelpers.parseDouble(args.get(index + 1)).isEmpty()) {
                return Optional.empty();
            }
            return this.tabDouble(args.get(index + 2), index + 3);
        }
        if (args.size() - index == 4) {
            if (StringHelpers.parseDouble(args.get(index + 1)).isEmpty()) {
                return Optional.empty();
            }
            if (StringHelpers.parseDouble(args.get(index + 2)).isEmpty()) {
                return Optional.empty();
            }
            return this.tabDouble(args.get(index + 3), index + 4);
        }
        return Optional.empty();
    }

    private Optional<ArgumentParser.TabCompletionResult> tabDouble(String s, int resultIndex) {
        int i;
        if (s.isEmpty()) {
            return Optional.of(new ArgumentParser.TabCompletionResult(Set.of("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "-", "."), resultIndex));
        }
        boolean onlyZero = true;
        boolean hasDot = false;
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (s.charAt(i2) == '-' || s.charAt(i2) == '+') {
                if (i2 == 0) continue;
                return Optional.empty();
            }
            if (s.charAt(i2) == '.') {
                if (hasDot) {
                    return Optional.empty();
                }
                hasDot = true;
                onlyZero = false;
                continue;
            }
            if (s.charAt(i2) == '0') {
                onlyZero = false;
                continue;
            }
            if (s.charAt(i2) >= '0' && s.charAt(57) <= '\t') continue;
            return Optional.empty();
        }
        HashSet<String> result = new HashSet<String>();
        int n = i = onlyZero ? 1 : 0;
        while (i < 10) {
            result.add(s + i);
            ++i;
        }
        if (!hasDot) {
            result.add(s + ".");
        }
        return Optional.of(new ArgumentParser.TabCompletionResult(result, resultIndex));
    }
}

