/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.spigot;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.apartium.cocoabeans.commands.ArgumentMapper;
import net.apartium.cocoabeans.commands.Command;
import net.apartium.cocoabeans.commands.CommandManager;
import net.apartium.cocoabeans.commands.CommandNode;
import net.apartium.cocoabeans.commands.Description;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.Usage;
import net.apartium.cocoabeans.commands.exception.ExceptionArgumentMapper;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.commands.spigot.SpigotArgumentMapper;
import net.apartium.cocoabeans.commands.spigot.SpigotSender;
import net.apartium.cocoabeans.commands.spigot.exception.SpigotExceptionArgumentMapper;
import net.apartium.cocoabeans.commands.spigot.parsers.GameModeParser;
import net.apartium.cocoabeans.commands.spigot.parsers.LocationParser;
import net.apartium.cocoabeans.commands.spigot.parsers.MaterialParser;
import net.apartium.cocoabeans.commands.spigot.parsers.OfflinePlayerParser;
import net.apartium.cocoabeans.commands.spigot.parsers.PlayerParser;
import net.apartium.cocoabeans.commands.spigot.requirements.Permission;
import net.apartium.cocoabeans.spigot.Commands;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;

public class SpigotCommandManager
extends CommandManager {
    public static final Set<ArgumentParser<?>> SPIGOT_PARSERS = Set.of(new PlayerParser(0), new OfflinePlayerParser(0), new MaterialParser(0), new LocationParser(0), new GameModeParser(0));
    private final JavaPlugin plugin;

    public SpigotCommandManager(JavaPlugin plugin) {
        this(plugin, new SpigotArgumentMapper(), new SpigotExceptionArgumentMapper());
    }

    public SpigotCommandManager(JavaPlugin plugin, ArgumentMapper argumentMapper, ExceptionArgumentMapper exceptionArgumentMapper) {
        super(argumentMapper, exceptionArgumentMapper);
        this.plugin = plugin;
    }

    @Override
    protected void addCommand(CommandNode commandNode, Command command) {
        org.bukkit.command.Command cmd = new org.bukkit.command.Command(command.value(), Optional.ofNullable(commandNode.getClass().getAnnotation(Description.class)).map(Description::value).orElse(""), Optional.ofNullable(commandNode.getClass().getAnnotation(Usage.class)).map(Usage::value).orElse(""), Arrays.asList(command.aliases())){

            public boolean execute(CommandSender sender, String invoke, String[] args) {
                String[] split = invoke.split(":");
                invoke = split[1 % split.length];
                try {
                    return SpigotCommandManager.this.handle(new SpigotSender<CommandSender>(sender), invoke, args);
                }
                catch (Throwable e) {
                    return false;
                }
            }

            public List<String> tabComplete(CommandSender sender, String invoke, String[] args) {
                String[] split = invoke.split(":");
                invoke = split[1 % split.length];
                return SpigotCommandManager.this.handleTabComplete(new SpigotSender<CommandSender>(sender), invoke, args);
            }
        };
        Optional.ofNullable(commandNode.getClass().getAnnotation(Permission.class)).map(Permission::value).ifPresent(arg_0 -> ((org.bukkit.command.Command)cmd).setPermission(arg_0));
        Commands.getCommandMap().register(this.plugin.getName().toLowerCase(), cmd);
    }

    @Override
    public boolean handle(Sender sender, String commandName, String[] args) throws Throwable {
        return super.handle(sender, commandName, args);
    }
}

