/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.spigot;

import java.util.List;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.requirements.Requirement;
import net.apartium.cocoabeans.commands.requirements.RequirementEvaluationContext;
import net.apartium.cocoabeans.commands.requirements.RequirementResult;
import net.apartium.cocoabeans.commands.requirements.UnmetRequirementResponse;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SenderType implements Requirement
{
    PLAYER{
        private static final String ERROR_MESSAGE = "This command can only be used by players";

        @Override
        public RequirementResult meetsRequirement(RequirementEvaluationContext context) {
            Sender sender = context.sender();
            if (sender == null || !(sender.getSender() instanceof Player)) {
                return RequirementResult.error(new UnmetRequirementResponse(this, context, ERROR_MESSAGE, null));
            }
            return RequirementResult.meet(RequirementResult.valueOf(PLAYER, SenderType.class));
        }

        @Override
        public List<Class<?>> getTypes() {
            return List.of(SenderType.class);
        }
    }
    ,
    BLOCK{
        private static final String ERROR_MESSAGE = "This command can only be used by command block";

        @Override
        public RequirementResult meetsRequirement(RequirementEvaluationContext context) {
            Sender sender = context.sender();
            if (sender == null || !(sender.getSender() instanceof BlockCommandSender)) {
                return RequirementResult.error(new UnmetRequirementResponse(this, context, ERROR_MESSAGE, null));
            }
            return RequirementResult.meet(RequirementResult.valueOf(BLOCK, SenderType.class));
        }

        @Override
        public List<Class<?>> getTypes() {
            return List.of(SenderType.class);
        }
    }
    ,
    CONSOLE{
        private static final String ERROR_MESSAGE = "This command can only be used by console";

        @Override
        public RequirementResult meetsRequirement(RequirementEvaluationContext context) {
            Sender sender = context.sender();
            if (sender == null || !(sender.getSender() instanceof ConsoleCommandSender)) {
                return RequirementResult.error(new UnmetRequirementResponse(this, context, ERROR_MESSAGE, null));
            }
            return RequirementResult.meet(RequirementResult.valueOf(CONSOLE, SenderType.class));
        }

        @Override
        public List<Class<?>> getTypes() {
            return List.of(SenderType.class);
        }
    }
    ,
    ENTITY{
        private static final String ERROR_MESSAGE = "This command can only be used by entities";

        @Override
        public RequirementResult meetsRequirement(RequirementEvaluationContext context) {
            Sender sender = context.sender();
            if (sender == null || !(sender.getSender() instanceof Entity)) {
                return RequirementResult.error(new UnmetRequirementResponse(this, context, ERROR_MESSAGE, null));
            }
            return RequirementResult.meet(RequirementResult.valueOf(ENTITY, SenderType.class));
        }

        @Override
        public List<Class<?>> getTypes() {
            return List.of(SenderType.class);
        }
    };

}

