/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.requirements.argument;

import net.apartium.cocoabeans.commands.CommandContext;
import net.apartium.cocoabeans.commands.CommandNode;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.requirements.ArgumentRequirement;
import net.apartium.cocoabeans.commands.requirements.ArgumentRequirementFactory;
import net.apartium.cocoabeans.commands.requirements.argument.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangeArgumentRequirementFactory
implements ArgumentRequirementFactory {
    @Override
    @Nullable
    public ArgumentRequirement getArgumentRequirement(CommandNode commandNode, Object obj) {
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Range)) {
            return null;
        }
        Range range = (Range)obj;
        return new RangeImpl(range.from(), range.to(), range.step());
    }

    public record RangeImpl(double from, double to, double step) implements ArgumentRequirement
    {
        @Override
        public boolean meetsRequirement(@NotNull Sender sender, @Nullable CommandContext context, @Nullable Object argument) {
            if (argument == null) {
                return false;
            }
            if (!(argument instanceof Double)) {
                return false;
            }
            double num = (Double)argument;
            if (num < this.from) {
                return false;
            }
            if (num >= this.to) {
                return false;
            }
            return (num - this.from) % this.step == 0.0;
        }
    }
}

