/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.commands.parsers.exception.InvalidUUIDResponse;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.36")
public class UUIDParser
extends ArgumentParser<UUID> {
    public static final String DEFAULT_KEYWORD = "uuid";

    public UUIDParser(String keyword, int priority) {
        super(keyword, UUID.class, priority);
    }

    public UUIDParser(int priority) {
        this(DEFAULT_KEYWORD, priority);
    }

    public UUIDParser() {
        this(0);
    }

    @Override
    public Optional<ArgumentParser.ParseResult<UUID>> parse(CommandProcessingContext processingContext) {
        List<String> args = processingContext.args();
        int startIndex = processingContext.index();
        if (startIndex >= args.size()) {
            return Optional.empty();
        }
        try {
            return Optional.of(new ArgumentParser.ParseResult<UUID>(UUID.fromString(args.get(startIndex)), startIndex + 1));
        }
        catch (IllegalArgumentException e) {
            processingContext.report(this, new InvalidUUIDResponse(processingContext, this, e.getMessage(), args.get(startIndex)));
            return Optional.empty();
        }
    }

    @Override
    public OptionalInt tryParse(CommandProcessingContext processingContext) {
        return this.parse(processingContext).map(ArgumentParser.ParseResult::newIndex).map(OptionalInt::of).orElse(OptionalInt.empty());
    }

    @Override
    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
        int startIndex = processingContext.index();
        return Optional.of(new ArgumentParser.TabCompletionResult(Set.of(), startIndex + 1));
    }
}

