/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.apartium.cocoabeans.Dispensers;
import net.apartium.cocoabeans.commands.CommandNode;
import net.apartium.cocoabeans.commands.parsers.MapBasedParser;
import net.apartium.cocoabeans.commands.parsers.ParserFactory;
import net.apartium.cocoabeans.commands.parsers.Scope;
import net.apartium.cocoabeans.commands.parsers.SourceParser;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class SourceParserFactory
implements ParserFactory {
    @Override
    @NotNull
    public Collection<ParserFactory.ParserResult> getArgumentParser(CommandNode commandNode, Annotation annotation, GenericDeclaration obj) {
        if (!(annotation instanceof SourceParser)) {
            return Collections.emptyList();
        }
        SourceParser sourceParser = (SourceParser)annotation;
        if (!(obj instanceof Method)) {
            return Collections.emptyList();
        }
        Method method = (Method)obj;
        if (!method.getReturnType().equals(Map.class)) {
            throw new RuntimeException("Wrong return type: " + method.getReturnType());
        }
        try {
            return List.of(new ParserFactory.ParserResult(new SourceParserImpl(commandNode, sourceParser.keyword(), sourceParser.clazz(), sourceParser.priority(), MethodHandles.publicLookup().unreflect(method), sourceParser.resultMaxAgeInMills(), sourceParser.ignoreCase(), sourceParser.lax()), Scope.CLASS));
        }
        catch (IllegalAccessException e) {
            Dispensers.dispense(e);
            return Collections.emptyList();
        }
    }

    private static class SourceParserImpl<T>
    extends MapBasedParser<T> {
        private final CommandNode node;
        private final MethodHandle handle;
        private final long resultMaxAgeInMills;
        private Instant nextCall = Instant.now();
        private Map<String, T> result = null;

        public SourceParserImpl(CommandNode node, String keyword, Class<T> clazz, int priority, MethodHandle handle, long resultMaxAgeInMills, boolean ignoreCase, boolean lax) {
            super(keyword, clazz, priority, ignoreCase, lax);
            this.node = node;
            this.handle = handle;
            this.resultMaxAgeInMills = resultMaxAgeInMills;
        }

        @Override
        public Map<String, T> getMap() {
            if (this.resultMaxAgeInMills == 0L) {
                return this.getResult();
            }
            if (this.result == null) {
                this.result = this.getResult();
            }
            if (this.resultMaxAgeInMills == -1L) {
                return this.result;
            }
            if (Instant.now().isAfter(this.nextCall)) {
                this.nextCall = Instant.now().plusMillis(this.resultMaxAgeInMills);
                this.result = this.getResult();
            }
            return this.result;
        }

        private Map<String, T> getResult() {
            try {
                return this.handle.invoke(this.node);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }
}

