/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.commands.parsers.exception.AmbiguousMappedKeyResponse;
import org.jetbrains.annotations.ApiStatus;

public abstract class MapBasedParser<T>
extends ArgumentParser<T> {
    private final boolean ignoreCase;
    private final boolean lax;

    public MapBasedParser(String keyword, Class<T> clazz, int priority) {
        this(keyword, clazz, priority, false);
    }

    @ApiStatus.AvailableSince(value="0.0.30")
    public MapBasedParser(String keyword, Class<T> clazz, int priority, boolean ignoreCase) {
        this(keyword, clazz, priority, ignoreCase, false);
    }

    @ApiStatus.AvailableSince(value="0.0.30")
    public MapBasedParser(String keyword, Class<T> clazz, int priority, boolean ignoreCase, boolean lax) {
        super(keyword, clazz, priority);
        this.ignoreCase = ignoreCase;
        this.lax = lax;
    }

    public abstract Map<String, T> getMap();

    @Override
    public Optional<ArgumentParser.ParseResult<T>> parse(CommandProcessingContext commandProcessingContext) {
        List<String> args = commandProcessingContext.args();
        int index = commandProcessingContext.index();
        Map<String, T> map = this.getMap();
        Object s = "";
        for (int i = index; i < args.size(); ++i) {
            T value;
            if (i != index) {
                s = (String)s + " ";
            }
            s = (String)s + args.get(index);
            if (this.ignoreCase) {
                s = ((String)s).toLowerCase();
            }
            if ((value = map.get(s)) == null && (!this.lax || (value = this.getLax(commandProcessingContext, (String)s)) == null)) continue;
            return Optional.of(new ArgumentParser.ParseResult<T>(value, i + 1));
        }
        return Optional.empty();
    }

    private T getLax(CommandProcessingContext context, String s) {
        T result = null;
        ArrayList<String> dupeKeys = new ArrayList<String>();
        for (Map.Entry<String, T> entry : this.getMap().entrySet()) {
            if (!entry.getKey().startsWith(s)) continue;
            if (result != null) {
                dupeKeys.add(entry.getKey());
                continue;
            }
            result = entry.getValue();
            dupeKeys.add(entry.getKey());
        }
        if (dupeKeys.isEmpty()) {
            return null;
        }
        if (dupeKeys.size() != 1) {
            context.report(this, new AmbiguousMappedKeyResponse(context, this, "Did you mean " + (String)dupeKeys.get(0) + "?", dupeKeys));
            return null;
        }
        return result;
    }

    @Override
    public OptionalInt tryParse(CommandProcessingContext commandProcessingContext) {
        return this.parse(commandProcessingContext).map(ArgumentParser.ParseResult::newIndex).map(OptionalInt::of).orElse(OptionalInt.empty());
    }

    @Override
    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext commandProcessingContext) {
        List<String> args = commandProcessingContext.args();
        int index = commandProcessingContext.index();
        Set<String> keys = this.getMap().keySet();
        HashSet<String> result = new HashSet<String>();
        String s = String.join((CharSequence)" ", args.subList(index, args.size()));
        for (String key : keys) {
            if (!key.toLowerCase().startsWith(s.toLowerCase())) continue;
            result.add(key);
        }
        if (result.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ArgumentParser.TabCompletionResult(result, args.size() + 1));
    }
}

