/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.parsers;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class BooleanParser
extends ArgumentParser<Boolean> {
    public static final String DEFAULT_KEYWORD = "boolean";
    private final Set<String> trueSet;
    private final Set<String> falseSet;
    private final Set<String> joinedSet;

    public BooleanParser(int priority) {
        this(priority, DEFAULT_KEYWORD);
    }

    @ApiStatus.AvailableSince(value="0.0.36")
    public BooleanParser(int priority, String keyword) {
        this(priority, keyword, Set.of("true"), Set.of("false"));
    }

    public BooleanParser(int priority, String keyword, @NotNull Set<String> trueSet, @NotNull Set<String> falseSet) {
        super(keyword, Boolean.TYPE, priority);
        if (trueSet.isEmpty()) {
            throw new RuntimeException("True set can't be empty");
        }
        if (falseSet.isEmpty()) {
            throw new RuntimeException("False set can't be empty");
        }
        this.trueSet = trueSet;
        this.falseSet = falseSet;
        HashSet<String> joinedSet = new HashSet<String>();
        joinedSet.addAll(trueSet);
        joinedSet.addAll(falseSet);
        this.joinedSet = Collections.unmodifiableSet(joinedSet);
    }

    @Override
    public Optional<ArgumentParser.ParseResult<Boolean>> parse(CommandProcessingContext processingContext) {
        int startIndex;
        List<String> args = processingContext.args();
        if (this.trueSet.contains(args.get(startIndex = processingContext.index()))) {
            return Optional.of(new ArgumentParser.ParseResult<Boolean>(true, startIndex + 1));
        }
        if (this.falseSet.contains(args.get(startIndex))) {
            return Optional.of(new ArgumentParser.ParseResult<Boolean>(false, startIndex + 1));
        }
        return Optional.empty();
    }

    @Override
    public OptionalInt tryParse(CommandProcessingContext processingContext) {
        int startIndex;
        List<String> args = processingContext.args();
        if (this.joinedSet.contains(args.get(startIndex = processingContext.index()))) {
            return OptionalInt.of(startIndex + 1);
        }
        return OptionalInt.empty();
    }

    @Override
    public Optional<ArgumentParser.TabCompletionResult> tabCompletion(CommandProcessingContext processingContext) {
        List<String> args = processingContext.args();
        int startIndex = processingContext.index();
        return Optional.of(new ArgumentParser.TabCompletionResult(this.joinedSet.stream().filter(s -> s.toLowerCase().startsWith(((String)args.get(startIndex)).toLowerCase())).collect(Collectors.toSet()), startIndex + 1));
    }
}

