/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands.exception;

import java.util.ArrayList;
import java.util.List;
import net.apartium.cocoabeans.commands.CommandContext;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.exception.BadCommandResponse;
import net.apartium.cocoabeans.commands.exception.CommandException;
import net.apartium.cocoabeans.commands.exception.ExceptionArgumentMapper;
import net.apartium.cocoabeans.commands.exception.HandleExceptionVariant;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.22")
public class SimpleExceptionArgumentMapper
implements ExceptionArgumentMapper {
    @Override
    public List<Object> map(HandleExceptionVariant handleExceptionVariant, CommandContext context, Sender sender, String commandName, String[] args, Throwable throwable) {
        Class<?>[] parameters = handleExceptionVariant.parameters();
        if (parameters.length == 0) {
            return List.of(handleExceptionVariant.commandNode());
        }
        ArrayList<Object> result = new ArrayList<Object>(parameters.length + 1);
        result.add(handleExceptionVariant.commandNode());
        for (Class<?> type : parameters) {
            BadCommandResponse commandError;
            if (Sender.class.isAssignableFrom(type)) {
                result.add(sender);
                continue;
            }
            if (type == CommandContext.class) {
                result.add(context);
                continue;
            }
            if (type == String.class) {
                result.add(commandName);
                continue;
            }
            if (type == String[].class) {
                result.add(args);
                continue;
            }
            if (type.isAssignableFrom(throwable.getClass())) {
                result.add(throwable);
                continue;
            }
            if (BadCommandResponse.class.isAssignableFrom(type) && throwable instanceof CommandException && type.isAssignableFrom((commandError = ((CommandException)throwable).getBadCommandResponse()).getClass())) {
                result.add(commandError);
                continue;
            }
            return null;
        }
        return result;
    }
}

