/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Function;
import net.apartium.cocoabeans.commands.ArgumentContext;
import net.apartium.cocoabeans.commands.ArgumentIndex;
import net.apartium.cocoabeans.commands.ArgumentMapper;
import net.apartium.cocoabeans.commands.CommandContext;
import net.apartium.cocoabeans.commands.RegisteredCommandVariant;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.commands.requirements.Requirement;
import net.apartium.cocoabeans.utils.OptionalFloat;

public class SimpleArgumentMapper
implements ArgumentMapper {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_MAP = Map.ofEntries(Map.entry(Byte.class, Byte.TYPE), Map.entry(Character.class, Character.TYPE), Map.entry(Short.class, Short.TYPE), Map.entry(Integer.class, Integer.TYPE), Map.entry(Long.class, Long.TYPE), Map.entry(Float.class, Float.TYPE), Map.entry(Double.class, Double.TYPE), Map.entry(Byte.TYPE, Byte.class), Map.entry(Character.TYPE, Character.class), Map.entry(Short.TYPE, Short.class), Map.entry(Integer.TYPE, Integer.class), Map.entry(Long.TYPE, Long.class), Map.entry(Float.TYPE, Float.class), Map.entry(Double.TYPE, Double.class));
    private static final Map<Class<?>, Class<?>> OPTIONAL_TO_PRIMITIVE_MAP = Map.of(OptionalInt.class, Integer.TYPE, OptionalLong.class, Long.TYPE, OptionalDouble.class, Double.TYPE, OptionalFloat.class, Float.TYPE);
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_OPTIMAL = Map.of(Integer.TYPE, OptionalInt.class, Long.TYPE, OptionalLong.class, Double.TYPE, OptionalDouble.class, Float.TYPE, OptionalFloat.class, Integer.class, OptionalInt.class, Long.class, OptionalLong.class, Double.class, OptionalDouble.class, Float.class, OptionalFloat.class);
    private static final Map<Class<?>, Object> EMPTY_OPTIONAL = Map.of(Integer.TYPE, OptionalInt.empty(), Integer.class, OptionalInt.empty(), Long.TYPE, OptionalLong.empty(), Long.class, OptionalLong.empty(), Double.TYPE, OptionalDouble.empty(), Double.class, OptionalDouble.empty(), Float.TYPE, OptionalFloat.empty(), Float.class, OptionalFloat.empty());
    private static final Map<Class<?>, Function<Object, Object>> OF_OPTIONAL = Map.of(Optional.class, Optional::of, OptionalInt.class, obj -> {
        if (obj == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of((Integer)obj);
    }, OptionalLong.class, obj -> {
        if (obj == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of((Long)obj);
    }, OptionalDouble.class, obj -> {
        if (obj == null || Double.isNaN((Double)obj)) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of((Double)obj);
    }, OptionalFloat.class, obj -> {
        if (obj == null || Float.isNaN(((Float)obj).floatValue())) {
            return OptionalFloat.empty();
        }
        return OptionalFloat.of(((Float)obj).floatValue());
    });

    @Override
    public List<ArgumentIndex<?>> mapIndices(RegisteredCommandVariant.Parameter[] parameters, List<ArgumentParser<?>> argumentParsers, List<Requirement> requirements) {
        if (parameters.length == 0) {
            return List.of();
        }
        ArrayList result = new ArrayList(parameters.length);
        HashMap counterMap = new HashMap();
        Map<Class<?>, List<ArgumentIndex<?>>> mapOfArguments = this.createParsedArgs(argumentParsers, requirements);
        for (RegisteredCommandVariant.Parameter parameter : parameters) {
            Class<?> type = parameter.type();
            boolean optional = false;
            boolean optionalPrimitive = false;
            if (type == Optional.class) {
                optional = true;
                type = this.getGenericType(parameter.parameterizedType());
            } else if (OPTIONAL_TO_PRIMITIVE_MAP.containsKey(type)) {
                type = OPTIONAL_TO_PRIMITIVE_MAP.get(type);
                optionalPrimitive = true;
            }
            int index = counterMap.computeIfAbsent(type, k -> 0);
            ArgumentIndex<Object> argumentIndex = this.resolveArgumentIndex(type, counterMap, mapOfArguments, index);
            if (optional) {
                argumentIndex = this.wrapInOptional(argumentIndex);
            }
            if (optionalPrimitive) {
                argumentIndex = this.wrapInOptionalPrimitive(argumentIndex, type);
            }
            result.add(argumentIndex);
            counterMap.put(type, (Integer)counterMap.get(type) + 1);
        }
        return result;
    }

    private Class<?> getGenericType(Type parameterizedType) {
        return (Class)((ParameterizedType)parameterizedType).getActualTypeArguments()[0];
    }

    private ArgumentIndex<Optional<?>> wrapInOptional(ArgumentIndex<?> argumentIndex) {
        return context -> {
            Object obj = argumentIndex.get(context);
            if (obj == null) {
                return Optional.empty();
            }
            if (obj instanceof Optional) {
                return (Optional)obj;
            }
            return Optional.of(obj);
        };
    }

    private ArgumentIndex<?> wrapInOptionalPrimitive(ArgumentIndex<?> argumentIndex, Class<?> type) {
        return context -> {
            Object obj = argumentIndex.get(context);
            if (obj instanceof Optional) {
                Optional opt = (Optional)obj;
                obj = opt.orElse(null);
            }
            if (obj == null) {
                return EMPTY_OPTIONAL.get(type);
            }
            return OF_OPTIONAL.get(PRIMITIVE_TO_OPTIMAL.get(type)).apply(obj);
        };
    }

    private ArgumentIndex<?> resolveArgumentIndex(Class<?> type, Map<Class<?>, Integer> counterMap, Map<Class<?>, List<ArgumentIndex<?>>> mapOfArguments, int index) {
        ArgumentIndex<?> argumentIndex = this.resolveBuiltInArgumentIndex(type, counterMap, mapOfArguments, index);
        if (argumentIndex != null) {
            return argumentIndex;
        }
        List<ArgumentIndex<?>> arguments = mapOfArguments.get(type);
        if (this.isInvalidArguments(arguments, index)) {
            arguments = this.findArgumentsByWrapperType(type, mapOfArguments);
        }
        if (this.isInvalidArguments(arguments, index)) {
            arguments = this.findArgumentsByAssignableType(type, mapOfArguments);
        }
        if (this.isInvalidArguments(arguments, index)) {
            throw new NoSuchElementException("No argument found for type " + type + " at index " + index);
        }
        return arguments.get(index);
    }

    private boolean isInvalidArguments(List<ArgumentIndex<?>> arguments, int index) {
        return arguments == null || arguments.size() <= index;
    }

    private List<ArgumentIndex<?>> findArgumentsByWrapperType(Class<?> type, Map<Class<?>, List<ArgumentIndex<?>>> mapOfArguments) {
        return mapOfArguments.get(PRIMITIVE_TO_WRAPPER_MAP.getOrDefault(type, type));
    }

    private List<ArgumentIndex<?>> findArgumentsByAssignableType(Class<?> type, Map<Class<?>, List<ArgumentIndex<?>>> mapOfArguments) {
        return mapOfArguments.entrySet().stream().filter(entry -> type.isAssignableFrom((Class)entry.getKey())).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    protected ArgumentIndex<?> resolveBuiltInArgumentIndex(Class<?> type, Map<Class<?>, Integer> counterMap, Map<Class<?>, List<ArgumentIndex<?>>> mapOfArguments, int index) {
        if (Sender.class.isAssignableFrom(type)) {
            return this.getSenderIndex(mapOfArguments, index);
        }
        if (CommandContext.class.equals(type)) {
            if (index != 0) {
                throw new IllegalArgumentException("Can't use index " + index + " for CommandContext");
            }
            return context -> context.parsedArgs().get(CommandContext.class).get(0);
        }
        return null;
    }

    private ArgumentIndex<?> getSenderIndex(Map<Class<?>, List<ArgumentIndex<?>>> mapOfArguments, int index) {
        if (index == 0) {
            return ArgumentContext::sender;
        }
        return mapOfArguments.get(Sender.class).get(index - 1);
    }

    private Map<Class<?>, List<ArgumentIndex<?>>> createParsedArgs(List<ArgumentParser<?>> argumentParsers, List<Requirement> requirements) {
        HashMap resultMap = new HashMap();
        HashMap counterMap = new HashMap();
        for (ArgumentParser<?> argumentParser : argumentParsers) {
            this.serializesArgumentIndex(argumentParser.getArgumentType(), counterMap, resultMap);
        }
        for (Requirement requirement : requirements) {
            for (Class<?> type : requirement.getTypes()) {
                this.serializesArgumentIndex(type, counterMap, resultMap);
            }
        }
        return resultMap;
    }

    private void serializesArgumentIndex(Class<?> type, Map<Class<?>, Integer> counterMap, Map<Class<?>, List<ArgumentIndex<?>>> resultMap) {
        int countIndex = counterMap.getOrDefault(type, 0);
        counterMap.put(type, countIndex + 1);
        resultMap.computeIfAbsent(type, k -> new ArrayList()).add(context -> context.parsedArgs().get(type).get(countIndex));
    }
}

