/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.apartium.cocoabeans.CollectionHelpers;
import net.apartium.cocoabeans.commands.CommandBranchProcessor;
import net.apartium.cocoabeans.commands.CommandInfo;
import net.apartium.cocoabeans.commands.CommandManager;
import net.apartium.cocoabeans.commands.CommandNode;
import net.apartium.cocoabeans.commands.CommandOption;
import net.apartium.cocoabeans.commands.RegisterArgumentParser;
import net.apartium.cocoabeans.commands.RegisteredCommandVariant;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.SubCommand;
import net.apartium.cocoabeans.commands.exception.ExceptionHandle;
import net.apartium.cocoabeans.commands.exception.HandleExceptionVariant;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.commands.parsers.CommandParserFactory;
import net.apartium.cocoabeans.commands.parsers.ParserFactory;
import net.apartium.cocoabeans.commands.requirements.ArgumentRequirement;
import net.apartium.cocoabeans.commands.requirements.ArgumentRequirementFactory;
import net.apartium.cocoabeans.commands.requirements.ArgumentRequirementType;
import net.apartium.cocoabeans.commands.requirements.CommandRequirementType;
import net.apartium.cocoabeans.commands.requirements.Requirement;
import net.apartium.cocoabeans.commands.requirements.RequirementFactory;
import net.apartium.cocoabeans.commands.requirements.RequirementSet;
import net.apartium.cocoabeans.reflect.ClassUtils;
import net.apartium.cocoabeans.reflect.MethodUtils;
import net.apartium.cocoabeans.structs.Entry;

class RegisteredCommand {
    private static final Comparator<HandleExceptionVariant> HANDLE_EXCEPTION_VARIANT_COMPARATOR = (a, b) -> Integer.compare(b.priority(), a.priority());
    private static final Comparator<RegisteredCommandVariant> REGISTERED_COMMAND_VARIANT_COMPARATOR = (a, b) -> Integer.compare(b.priority(), a.priority());
    private final CommandManager commandManager;
    private final List<RegisteredCommandNode> commands = new ArrayList<RegisteredCommandNode>();
    private final List<HandleExceptionVariant> handleExceptionVariants = new ArrayList<HandleExceptionVariant>();
    private final CommandBranchProcessor commandBranchProcessor;
    private final CommandInfo commandInfo = new CommandInfo();

    RegisteredCommand(CommandManager commandManager) {
        this.commandManager = commandManager;
        this.commandBranchProcessor = new CommandBranchProcessor(commandManager);
    }

    public void addNode(CommandNode node) {
        Method fallbackHandle;
        Class<?> clazz = node.getClass();
        this.commandInfo.fromAnnotations(clazz.getAnnotations(), false);
        RequirementSet requirementSet = new RequirementSet(this.findAllRequirements(node, clazz));
        try {
            fallbackHandle = clazz.getMethod("fallbackHandle", Sender.class, String.class, String[].class);
        }
        catch (Exception e) {
            throw new RuntimeException("What is going on here", e);
        }
        this.commands.add(new RegisteredCommandNode(node, new RequirementSet(requirementSet, this.createRequirementSet(node, fallbackHandle.getAnnotations()))));
        HashMap argumentTypeHandlerMap = new HashMap();
        MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
        for (Class<?> clazz2 : ClassUtils.getSuperClassAndInterfaces(clazz)) {
            for (Map.Entry<String, ArgumentParser<?>> entry : this.serializeArgumentTypeHandler(node, clazz2.getAnnotations(), clazz2, true).entrySet()) {
                argumentTypeHandlerMap.putIfAbsent(entry.getKey(), entry.getValue());
            }
            for (Method method : clazz.getMethods()) {
                try {
                    this.addParsers(node, argumentTypeHandlerMap, method, clazz2.getMethod(method.getName(), method.getParameterTypes()), true);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        for (Map.Entry entry : this.commandManager.argumentTypeHandlerMap.entrySet()) {
            argumentTypeHandlerMap.putIfAbsent((String)entry.getKey(), (ArgumentParser)entry.getValue());
        }
        ArrayList<Requirement> classRequirementsResult = new ArrayList<Requirement>();
        CommandOption commandOption = this.createCommandOption(requirementSet, this.commandBranchProcessor, classRequirementsResult);
        for (Method method : clazz.getMethods()) {
            SubCommand[] subCommands;
            for (SubCommand subCommand : subCommands = (SubCommand[])method.getAnnotationsByType(SubCommand.class)) {
                this.parseSubCommand(method, subCommand, clazz, argumentTypeHandlerMap, requirementSet, publicLookup, node, commandOption, new ArrayList(), new ArrayList<Requirement>(classRequirementsResult));
            }
            ExceptionHandle exceptionHandle = method.getAnnotation(ExceptionHandle.class);
            if (exceptionHandle != null) {
                try {
                    CollectionHelpers.addElementSorted(this.handleExceptionVariants, new HandleExceptionVariant(publicLookup.unreflect(method), (Class[])Arrays.stream(method.getParameters()).map(Parameter::getType).toArray(Class[]::new), node, exceptionHandle.priority()), HANDLE_EXCEPTION_VARIANT_COMPARATOR);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            for (Method targetMethod : MethodUtils.getMethodsFromSuperClassAndInterface(method)) {
                this.handleSubCommand(node, clazz, requirementSet, argumentTypeHandlerMap, publicLookup, commandOption, method, targetMethod, classRequirementsResult);
            }
        }
    }

    private void handleSubCommand(CommandNode node, Class<?> clazz, RequirementSet requirementSet, Map<String, ArgumentParser<?>> argumentTypeHandlerMap, MethodHandles.Lookup publicLookup, CommandOption commandOption, Method method, Method targetMethod, List<Requirement> classRequirementsResult) {
        SubCommand[] superSubCommands;
        if (targetMethod == null) {
            return;
        }
        for (SubCommand subCommand : superSubCommands = (SubCommand[])targetMethod.getAnnotationsByType(SubCommand.class)) {
            this.parseSubCommand(method, subCommand, clazz, argumentTypeHandlerMap, requirementSet, publicLookup, node, commandOption, new ArrayList(), new ArrayList<Requirement>(classRequirementsResult));
        }
        ExceptionHandle exceptionHandle = targetMethod.getAnnotation(ExceptionHandle.class);
        if (exceptionHandle != null) {
            try {
                CollectionHelpers.addElementSorted(this.handleExceptionVariants, new HandleExceptionVariant(publicLookup.unreflect(method), (Class[])Arrays.stream(method.getParameters()).map(Parameter::getType).toArray(Class[]::new), node, exceptionHandle.priority()), HANDLE_EXCEPTION_VARIANT_COMPARATOR);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void addParsers(CommandNode node, Map<String, ArgumentParser<?>> argumentTypeHandlerMap, Method method, Method targetMethod, boolean onlyClassParser) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = targetMethod.getAnnotations()) {
            this.handleParserFactories(node, method, argumentTypeHandlerMap, annotation, onlyClassParser);
        }
    }

    private void parseSubCommand(Method method, SubCommand subCommand, Class<?> clazz, Map<String, ArgumentParser<?>> argumentTypeHandlerMap, RequirementSet requirementSet, MethodHandles.Lookup publicLookup, CommandNode node, CommandOption commandOption, List<ArgumentParser<?>> parsersResult, List<Requirement> requirementsResult) {
        if (subCommand == null) {
            return;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new RuntimeException("Static method " + clazz.getName() + "#" + method.getName() + " is not supported");
        }
        HashMap methodArgumentTypeHandlerMap = new HashMap(this.serializeArgumentTypeHandler(node, method.getAnnotations(), method, false));
        for (Method method2 : MethodUtils.getMethodsFromSuperClassAndInterface(method)) {
            Map<String, ArgumentParser<?>> withParserMap = this.serializeArgumentTypeHandler(node, method2.getAnnotations(), method2, false);
            for (Map.Entry<String, ArgumentParser<?>> entry2 : withParserMap.entrySet()) {
                if (methodArgumentTypeHandlerMap.containsKey(entry2.getKey())) continue;
                methodArgumentTypeHandlerMap.put(entry2.getKey(), entry2.getValue());
            }
        }
        for (Map.Entry entry2 : argumentTypeHandlerMap.entrySet()) {
            if (methodArgumentTypeHandlerMap.containsKey(entry2.getKey())) continue;
            methodArgumentTypeHandlerMap.put((String)entry2.getKey(), (ArgumentParser)entry2.getValue());
        }
        CommandInfo methodInfo = new CommandInfo();
        methodInfo.fromAnnotations(method.getAnnotations(), true);
        for (Method targetMethod : MethodUtils.getMethodsFromSuperClassAndInterface(method)) {
            methodInfo.fromAnnotations(targetMethod.getAnnotations(), false);
        }
        RequirementSet requirementSet2 = new RequirementSet(this.findAllRequirements(node, method), requirementSet);
        String[] split = subCommand.value().split("\\s+");
        if (split.length == 0 || split.length == 1 && split[0].isEmpty()) {
            CommandOption cmdOption = this.createCommandOption(requirementSet2, this.commandBranchProcessor, requirementsResult);
            cmdOption.getCommandInfo().fromCommandInfo(methodInfo);
            RegisteredCommandVariant.Parameter[] parameters = this.serializeParameters(node, method.getParameters());
            try {
                CollectionHelpers.addElementSorted(cmdOption.getRegisteredCommandVariants(), new RegisteredCommandVariant(publicLookup.unreflect(method), parameters, node, this.commandManager.getArgumentMapper().mapIndices(parameters, parsersResult, requirementsResult), subCommand.priority()), REGISTERED_COMMAND_VARIANT_COMPARATOR);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing method", e);
            }
            return;
        }
        CommandOption currentCommandOption = commandOption;
        for (int index = 0; index < split.length; ++index) {
            RequirementSet requirements;
            String cmd = split[index];
            RequirementSet requirementSet3 = requirements = index == 0 ? requirementSet2 : new RequirementSet();
            if (cmd.startsWith("<") && cmd.endsWith(">")) {
                CommandBranchProcessor branchProcessor;
                CommandBranchProcessor commandBranchProcessor;
                boolean isOptional = cmd.startsWith("<?") || cmd.startsWith("<!?");
                boolean isInvalid = cmd.startsWith("<!") || cmd.startsWith("<?!");
                ArgumentParser typeParser = (ArgumentParser)methodArgumentTypeHandlerMap.get(cmd.substring(1 + (isInvalid ? 1 : 0) + (isOptional ? 1 : 0), cmd.length() - 1));
                if (typeParser == null) {
                    throw new RuntimeException("Couldn't resolve " + clazz.getName() + "#" + method.getName() + " parser: " + cmd.substring(1, cmd.length() - 1));
                }
                RegisterArgumentParser finalTypeParser = new RegisterArgumentParser(typeParser, isInvalid, isOptional);
                Entry entryArgument = currentCommandOption.getArgumentTypeHandlerMap().stream().filter(entry -> ((RegisterArgumentParser)entry.key()).equals(finalTypeParser)).findAny().orElse(null);
                CommandBranchProcessor commandBranchProcessor2 = commandBranchProcessor = entryArgument == null ? null : (CommandBranchProcessor)entryArgument.value();
                if (commandBranchProcessor == null) {
                    commandBranchProcessor = new CommandBranchProcessor(this.commandManager);
                    CollectionHelpers.addElementSorted(currentCommandOption.getArgumentTypeHandlerMap(), new Entry(finalTypeParser, commandBranchProcessor), (a, b) -> ((RegisterArgumentParser)b.key()).compareTo((ArgumentParser)a.key()));
                }
                parsersResult.add(entryArgument == null ? finalTypeParser : (ArgumentParser)entryArgument.key());
                if (finalTypeParser.isOptional() && (branchProcessor = (CommandBranchProcessor)currentCommandOption.getOptionalArgumentTypeHandlerMap().stream().filter(entry -> ((RegisterArgumentParser)entry.key()).equals(finalTypeParser)).findAny().map(Entry::value).orElse(null)) == null) {
                    branchProcessor = commandBranchProcessor;
                    CollectionHelpers.addElementSorted(currentCommandOption.getOptionalArgumentTypeHandlerMap(), new Entry(finalTypeParser, branchProcessor), (a, b) -> ((RegisterArgumentParser)b.key()).compareTo((ArgumentParser)a.key()));
                }
                currentCommandOption = this.createCommandOption(requirements, commandBranchProcessor, requirementsResult);
                continue;
            }
            Map<String, CommandBranchProcessor> keywordMap = subCommand.ignoreCase() ? currentCommandOption.getKeywordIgnoreCaseMap() : currentCommandOption.getKeywordMap();
            CommandBranchProcessor commandBranchProcessor = keywordMap.computeIfAbsent(subCommand.ignoreCase() ? cmd.toLowerCase() : cmd, key -> new CommandBranchProcessor(this.commandManager));
            currentCommandOption = this.createCommandOption(requirements, commandBranchProcessor, requirementsResult);
        }
        currentCommandOption.getCommandInfo().fromCommandInfo(methodInfo);
        RegisteredCommandVariant.Parameter[] parameters = this.serializeParameters(node, method.getParameters());
        try {
            CollectionHelpers.addElementSorted(currentCommandOption.getRegisteredCommandVariants(), new RegisteredCommandVariant(publicLookup.unreflect(method), parameters, node, this.commandManager.getArgumentMapper().mapIndices(parameters, parsersResult, requirementsResult), subCommand.priority()), REGISTERED_COMMAND_VARIANT_COMPARATOR);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error accessing method", e);
        }
    }

    private RegisteredCommandVariant.Parameter[] serializeParameters(CommandNode commandNode, Parameter[] parameters) {
        RegisteredCommandVariant.Parameter[] result = new RegisteredCommandVariant.Parameter[parameters.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new RegisteredCommandVariant.Parameter(parameters[i].getType(), parameters[i].getParameterizedType(), this.serializeArgumentRequirement(commandNode, parameters[i].getAnnotations()));
        }
        return result;
    }

    private ArgumentRequirement[] serializeArgumentRequirement(CommandNode commandNode, Annotation[] annotations) {
        ArrayList<ArgumentRequirement> result = new ArrayList<ArgumentRequirement>();
        for (Annotation annotation : annotations) {
            ArgumentRequirement argumentRequirement;
            ArgumentRequirementFactory factory;
            ArgumentRequirementType argumentRequirementType = annotation.annotationType().getAnnotation(ArgumentRequirementType.class);
            if (argumentRequirementType == null || (factory = this.commandManager.argumentRequirementFactories.computeIfAbsent(argumentRequirementType.value(), clazz -> {
                try {
                    Constructor<? extends ArgumentRequirementFactory> constructor = argumentRequirementType.value().getConstructor(new Class[0]);
                    if (constructor.getParameterCount() == 0) {
                        return constructor.newInstance(new Object[0]);
                    }
                    if (constructor.getParameters().length == 1 && constructor.getParameterTypes()[0].equals(CommandManager.class)) {
                        return constructor.newInstance(this.commandManager);
                    }
                    return null;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    return null;
                }
            })) == null || (argumentRequirement = factory.getArgumentRequirement(commandNode, annotation)) == null) continue;
            result.add(argumentRequirement);
        }
        return result.toArray(new ArgumentRequirement[0]);
    }

    private CommandOption createCommandOption(RequirementSet requirements, CommandBranchProcessor commandBranchProcessor, List<Requirement> requirementsResult) {
        CommandOption cmdOption = commandBranchProcessor.objectMap.stream().filter(entry -> ((RequirementSet)entry.key()).equals(requirements)).findAny().map(Entry::value).orElse(null);
        if (cmdOption == null) {
            cmdOption = new CommandOption(this.commandManager);
            commandBranchProcessor.objectMap.add(new Entry<RequirementSet, CommandOption>(requirements, cmdOption));
        }
        requirementsResult.addAll(requirements);
        return cmdOption;
    }

    private Set<Requirement> findAllRequirements(CommandNode commandNode, Class<?> clazz) {
        HashSet<Requirement> requirements = new HashSet<Requirement>();
        for (Class<?> c : ClassUtils.getSuperClassAndInterfaces(clazz)) {
            requirements.addAll(this.createRequirementSet(commandNode, c.getAnnotations()));
        }
        return requirements;
    }

    private Set<Requirement> findAllRequirements(CommandNode commandNode, Method method) {
        HashSet<Requirement> requirements = new HashSet<Requirement>(this.createRequirementSet(commandNode, method.getAnnotations()));
        for (Method target : MethodUtils.getMethodsFromSuperClassAndInterface(method)) {
            requirements.addAll(this.createRequirementSet(commandNode, target.getAnnotations()));
        }
        return requirements;
    }

    private Requirement getRequirement(CommandNode commandNode, Annotation annotation) {
        CommandRequirementType commandRequirementType = annotation.annotationType().getAnnotation(CommandRequirementType.class);
        if (commandRequirementType == null) {
            return null;
        }
        RequirementFactory requirementFactory = this.commandManager.requirementFactories.computeIfAbsent(commandRequirementType.value(), clazz -> {
            try {
                return commandRequirementType.value().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
        });
        if (requirementFactory == null) {
            return null;
        }
        return requirementFactory.getRequirement(commandNode, annotation);
    }

    private Set<Requirement> createRequirementSet(CommandNode commandNode, Annotation[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return Collections.emptySet();
        }
        HashSet<Requirement> requirements = new HashSet<Requirement>();
        for (Annotation annotation : annotations) {
            Requirement requirement = this.getRequirement(commandNode, annotation);
            if (requirement == null) continue;
            requirements.add(requirement);
        }
        return requirements;
    }

    private Map<String, ArgumentParser<?>> serializeArgumentTypeHandler(CommandNode commandNode, Annotation[] annotations, GenericDeclaration obj, boolean onlyClassParser) {
        HashMap argumentTypeHandlerMap = new HashMap();
        if (annotations == null) {
            return argumentTypeHandlerMap;
        }
        for (Annotation annotation : annotations) {
            this.handleParserFactories(commandNode, obj, argumentTypeHandlerMap, annotation, onlyClassParser);
        }
        return argumentTypeHandlerMap;
    }

    private void handleParserFactories(CommandNode commandNode, GenericDeclaration obj, Map<String, ArgumentParser<?>> argumentTypeHandlerMap, Annotation annotation, boolean onlyClassParser) {
        CommandParserFactory commandParserFactory = annotation.annotationType().getAnnotation(CommandParserFactory.class);
        if (commandParserFactory == null) {
            return;
        }
        if (!commandParserFactory.scope().isClass() && onlyClassParser) {
            return;
        }
        ParserFactory parserFactory = this.commandManager.parserFactories.computeIfAbsent(commandParserFactory.value(), clazz -> {
            try {
                return commandParserFactory.value().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
        });
        if (parserFactory == null) {
            return;
        }
        Collection<ParserFactory.ParserResult> parserResults = parserFactory.getArgumentParser(commandNode, annotation, obj);
        if (parserResults.isEmpty()) {
            return;
        }
        for (ParserFactory.ParserResult parseResult : parserResults) {
            if (!parseResult.scope().isClass() && onlyClassParser) continue;
            argumentTypeHandlerMap.put(parseResult.parser().getKeyword(), parseResult.parser());
        }
    }

    public CommandInfo getCommandInfo() {
        return this.commandInfo;
    }

    public List<RegisteredCommandNode> getCommands() {
        return this.commands;
    }

    public CommandBranchProcessor getCommandBranchProcessor() {
        return this.commandBranchProcessor;
    }

    public Iterable<HandleExceptionVariant> getHandleExceptionVariants() {
        return this.handleExceptionVariants;
    }

    public record RegisteredCommandNode(CommandNode listener, RequirementSet requirements) {
    }
}

