/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.apartium.cocoabeans.commands.AbstractCommandProcessingContext;
import net.apartium.cocoabeans.commands.CommandBranchProcessor;
import net.apartium.cocoabeans.commands.CommandContext;
import net.apartium.cocoabeans.commands.CommandInfo;
import net.apartium.cocoabeans.commands.CommandManager;
import net.apartium.cocoabeans.commands.RegisterArgumentParser;
import net.apartium.cocoabeans.commands.RegisteredCommand;
import net.apartium.cocoabeans.commands.RegisteredCommandVariant;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.exception.InvalidUsageResponse;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.structs.Entry;
import org.jetbrains.annotations.Nullable;

class CommandOption {
    private final CommandManager commandManager;
    private final List<RegisteredCommandVariant> registeredCommandVariants = new ArrayList<RegisteredCommandVariant>();
    private final CommandInfo commandInfo = new CommandInfo();
    private final Map<String, CommandBranchProcessor> keywordIgnoreCaseMap = new HashMap<String, CommandBranchProcessor>();
    private final Map<String, CommandBranchProcessor> keywordMap = new HashMap<String, CommandBranchProcessor>();
    private final List<Entry<RegisterArgumentParser<?>, CommandBranchProcessor>> argumentTypeHandlerMap = new ArrayList();
    private final List<Entry<RegisterArgumentParser<?>, CommandBranchProcessor>> argumentTypeOptionalHandlerMap = new ArrayList();

    CommandOption(CommandManager commandManager) {
        this.commandManager = commandManager;
    }

    public CommandContext handle(RegisteredCommand registeredCommand, String commandName, String[] args, Sender sender, int index) {
        if (args.length == 0 && index == 0) {
            if (!this.registeredCommandVariants.isEmpty() && this.argumentTypeOptionalHandlerMap.isEmpty()) {
                return new CommandContext(sender, this.commandInfo, this, null, args, commandName, new HashMap());
            }
            return this.handleOptional(registeredCommand, commandName, args, sender, index);
        }
        if (args.length <= index) {
            return this.handleOptional(registeredCommand, commandName, args, sender, index);
        }
        CommandContext commandError = null;
        CommandBranchProcessor commandBranchProcessor = this.keywordMap.get(args[index]);
        if (commandBranchProcessor == null) {
            commandBranchProcessor = this.keywordIgnoreCaseMap.get(args[index].toLowerCase());
        }
        if (commandBranchProcessor != null) {
            CommandContext result = commandBranchProcessor.handle(registeredCommand, commandName, args, sender, index + 1);
            if (result != null && !result.hasError()) {
                return result;
            }
            commandError = result;
        }
        AbstractCommandProcessingContext context = new AbstractCommandProcessingContext(sender, commandName, args, index);
        for (Entry<RegisterArgumentParser<?>, CommandBranchProcessor> entry : this.argumentTypeHandlerMap) {
            ArgumentParser<?> typeParser = entry.key().parser();
            context.clearReports();
            Optional<ArgumentParser.ParseResult<?>> parse = typeParser.parse(context);
            if (parse.isEmpty()) {
                if (!entry.key().optionalNotMatch()) {
                    if (context.getReport() == null || commandError != null && commandError.error().getDepth() >= context.getReport().getDepth()) continue;
                    commandError = new CommandContext(sender, null, null, context.getReport(), args, commandName, new HashMap());
                    continue;
                }
                CommandContext result = entry.value().handle(registeredCommand, commandName, args, sender, index + 1);
                if (result == null) continue;
                if (result.hasError()) {
                    if (commandError != null && commandError.error().getDepth() >= result.error().getDepth()) continue;
                    commandError = result;
                    continue;
                }
                result.parsedArgs().computeIfAbsent(typeParser.getArgumentType(), clazz -> new ArrayList()).add(0, Optional.empty());
                return result;
            }
            int newIndex = parse.get().newIndex();
            if (newIndex <= index) {
                throw new RuntimeException("There is an exception with " + typeParser.getClass().getName() + " return new index that isn't bigger than current index");
            }
            CommandContext result = entry.value().handle(registeredCommand, commandName, args, sender, newIndex);
            if (result == null) continue;
            if (result.hasError()) {
                if (commandError != null && commandError.error().getDepth() >= result.error().getDepth()) continue;
                commandError = result;
                continue;
            }
            result.parsedArgs().computeIfAbsent(typeParser.getArgumentType(), clazz -> new ArrayList()).add(0, parse.get().result());
            return result;
        }
        if (commandError != null) {
            return commandError;
        }
        return new CommandContext(sender, null, null, new InvalidUsageResponse(commandName, args, index), args, commandName, Map.of());
    }

    @Nullable
    CommandContext handleOptional(RegisteredCommand registeredCommand, String commandName, String[] args, Sender sender, int index) {
        CommandContext error = null;
        for (Entry<RegisterArgumentParser<?>, CommandBranchProcessor> entry : this.argumentTypeOptionalHandlerMap) {
            CommandContext result = entry.value().handle(registeredCommand, commandName, args, sender, index + 1);
            if (result == null) {
                if (this.registeredCommandVariants.isEmpty()) continue;
                return new CommandContext(sender, this.commandInfo, this, null, args, commandName, new HashMap());
            }
            if (result.hasError()) {
                if (error != null && error.error().getDepth() >= result.error().getDepth()) continue;
                error = result;
                continue;
            }
            result.parsedArgs().computeIfAbsent(entry.key().parser().getArgumentType(), clazz -> new ArrayList()).add(0, Optional.empty());
            return result;
        }
        return null;
    }

    public Set<String> handleTabCompletion(RegisteredCommand registeredCommand, String commandName, String[] args, Sender sender, int index) {
        Set<String> set;
        Set<String> set2;
        if (args.length <= index) {
            return Set.of();
        }
        if (args.length - 1 == index) {
            HashSet<String> result = new HashSet<String>();
            for (Map.Entry<String, CommandBranchProcessor> entry : this.keywordMap.entrySet()) {
                if (!entry.getKey().startsWith(args[index]) || !entry.getValue().haveAnyRequirementsMeet(sender, commandName, args, index)) continue;
                result.add(entry.getKey());
            }
            for (Map.Entry<String, CommandBranchProcessor> entry : this.keywordIgnoreCaseMap.entrySet()) {
                if (!entry.getKey().startsWith(args[index].toLowerCase()) || !entry.getValue().haveAnyRequirementsMeet(sender, commandName, args, index)) continue;
                result.add(entry.getKey());
            }
            for (Entry entry : this.argumentTypeHandlerMap) {
                if (!((CommandBranchProcessor)entry.value()).haveAnyRequirementsMeet(sender, commandName, args, index)) continue;
                Optional<ArgumentParser.TabCompletionResult> tabCompletionResult = ((RegisterArgumentParser)entry.key()).tabCompletion(new AbstractCommandProcessingContext(sender, commandName, args, index));
                if (tabCompletionResult.isEmpty()) {
                    if (!((RegisterArgumentParser)entry.key()).isOptional() || !((RegisterArgumentParser)entry.key()).optionalNotMatch()) continue;
                    result.addAll(((CommandBranchProcessor)entry.value()).handleTabCompletion(registeredCommand, commandName, args, sender, index + 1));
                    continue;
                }
                result.addAll(tabCompletionResult.get().result());
            }
            return result;
        }
        HashSet<String> result = new HashSet<String>();
        CommandBranchProcessor commandBranchProcessor = this.keywordMap.get(args[index]);
        if (commandBranchProcessor != null && !(set2 = commandBranchProcessor.handleTabCompletion(registeredCommand, commandName, args, sender, index + 1)).isEmpty()) {
            result.addAll(set2);
        }
        if ((commandBranchProcessor = this.keywordIgnoreCaseMap.get(args[index].toLowerCase())) != null && !(set = commandBranchProcessor.handleTabCompletion(registeredCommand, commandName, args, sender, index + 1)).isEmpty()) {
            result.addAll(set);
        }
        for (Entry<RegisterArgumentParser<?>, CommandBranchProcessor> entry : this.argumentTypeHandlerMap) {
            Optional<ArgumentParser.TabCompletionResult> tabCompletionResult;
            ArgumentParser typeParser = entry.key();
            OptionalInt parse = typeParser.tryParse(new AbstractCommandProcessingContext(sender, commandName, args, index));
            if (parse.isEmpty()) {
                if (!entry.value().haveAnyRequirementsMeet(sender, commandName, args, index)) continue;
                Optional<ArgumentParser.TabCompletionResult> tabCompletionResult2 = entry.key().tabCompletion(new AbstractCommandProcessingContext(sender, commandName, args, index));
                if (tabCompletionResult2.isEmpty()) {
                    if (!entry.key().isOptional() || !entry.key().optionalNotMatch()) continue;
                    result.addAll(entry.value().handleTabCompletion(registeredCommand, commandName, args, sender, index + 1));
                    continue;
                }
                if (tabCompletionResult2.get().newIndex() < args.length) continue;
                result.addAll(tabCompletionResult2.get().result());
                continue;
            }
            if (parse.getAsInt() <= args.length && entry.value().haveAnyRequirementsMeet(sender, commandName, args, index) && (tabCompletionResult = entry.key().tabCompletion(new AbstractCommandProcessingContext(sender, commandName, args, index))).isPresent() && tabCompletionResult.get().newIndex() >= args.length) {
                result.addAll(tabCompletionResult.get().result().stream().toList());
                continue;
            }
            int newIndex = parse.getAsInt();
            if (newIndex <= index) {
                throw new RuntimeException("There is an exception with " + typeParser.getClass().getName() + " return new index that isn't bigger then current index");
            }
            Set<String> strings2 = entry.value().handleTabCompletion(registeredCommand, commandName, args, sender, newIndex);
            if (strings2.isEmpty()) continue;
            result.addAll(strings2);
        }
        return result;
    }

    public List<RegisteredCommandVariant> getRegisteredCommandVariants() {
        return this.registeredCommandVariants;
    }

    public CommandInfo getCommandInfo() {
        return this.commandInfo;
    }

    public List<Entry<RegisterArgumentParser<?>, CommandBranchProcessor>> getArgumentTypeHandlerMap() {
        return this.argumentTypeHandlerMap;
    }

    public List<Entry<RegisterArgumentParser<?>, CommandBranchProcessor>> getOptionalArgumentTypeHandlerMap() {
        return this.argumentTypeOptionalHandlerMap;
    }

    public Map<String, CommandBranchProcessor> getKeywordIgnoreCaseMap() {
        return this.keywordIgnoreCaseMap;
    }

    public Map<String, CommandBranchProcessor> getKeywordMap() {
        return this.keywordMap;
    }
}

