/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.apartium.cocoabeans.Dispensers;
import net.apartium.cocoabeans.commands.ArgumentMapper;
import net.apartium.cocoabeans.commands.Command;
import net.apartium.cocoabeans.commands.CommandContext;
import net.apartium.cocoabeans.commands.CommandInfo;
import net.apartium.cocoabeans.commands.CommandNode;
import net.apartium.cocoabeans.commands.RegisteredCommand;
import net.apartium.cocoabeans.commands.RegisteredCommandVariant;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.exception.BadCommandResponse;
import net.apartium.cocoabeans.commands.exception.ExceptionArgumentMapper;
import net.apartium.cocoabeans.commands.exception.HandleExceptionVariant;
import net.apartium.cocoabeans.commands.exception.UnknownCommandResponse;
import net.apartium.cocoabeans.commands.parsers.ArgumentParser;
import net.apartium.cocoabeans.commands.parsers.BooleanParser;
import net.apartium.cocoabeans.commands.parsers.DoubleParser;
import net.apartium.cocoabeans.commands.parsers.FloatParser;
import net.apartium.cocoabeans.commands.parsers.IntParser;
import net.apartium.cocoabeans.commands.parsers.LongParser;
import net.apartium.cocoabeans.commands.parsers.ParserFactory;
import net.apartium.cocoabeans.commands.parsers.StringParser;
import net.apartium.cocoabeans.commands.parsers.StringsParser;
import net.apartium.cocoabeans.commands.requirements.ArgumentRequirement;
import net.apartium.cocoabeans.commands.requirements.ArgumentRequirementFactory;
import net.apartium.cocoabeans.commands.requirements.RequirementEvaluationContext;
import net.apartium.cocoabeans.commands.requirements.RequirementFactory;
import net.apartium.cocoabeans.commands.requirements.RequirementResult;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public abstract class CommandManager {
    public static final Set<ArgumentParser<?>> COMMON_PARSERS = Set.of(new IntParser(0), new LongParser(0), new FloatParser(0), new DoubleParser(0), new BooleanParser(0), new StringParser(0), new StringsParser(0));
    protected final Map<String, RegisteredCommand> commandMap = new HashMap<String, RegisteredCommand>();
    private final ArgumentMapper argumentMapper;
    private final ExceptionArgumentMapper exceptionArgumentMapper;
    final Map<Class<? extends ParserFactory>, ParserFactory> parserFactories = new HashMap<Class<? extends ParserFactory>, ParserFactory>();
    final Map<Class<? extends ArgumentRequirementFactory>, ArgumentRequirementFactory> argumentRequirementFactories = new HashMap<Class<? extends ArgumentRequirementFactory>, ArgumentRequirementFactory>();
    final Map<Class<? extends RequirementFactory>, RequirementFactory> requirementFactories = new HashMap<Class<? extends RequirementFactory>, RequirementFactory>();
    final Map<String, ArgumentParser<?>> argumentTypeHandlerMap = new HashMap();

    public CommandManager(ArgumentMapper argumentMapper, ExceptionArgumentMapper exceptionArgumentMapper) {
        this.argumentMapper = argumentMapper;
        this.exceptionArgumentMapper = exceptionArgumentMapper;
    }

    public void registerArgumentTypeHandler(ArgumentParser<?> argumentTypeHandler) {
        this.argumentTypeHandlerMap.put(argumentTypeHandler.getKeyword(), argumentTypeHandler);
    }

    public void registerArgumentTypeHandler(Set<ArgumentParser<?>> argumentTypeHandlers) {
        for (ArgumentParser<?> argumentTypeHandler : argumentTypeHandlers) {
            this.registerArgumentTypeHandler(argumentTypeHandler);
        }
    }

    public List<String> handleTabComplete(Sender sender, String commandName, String[] args) {
        RegisteredCommand registeredCommand = this.commandMap.get(commandName.toLowerCase());
        if (registeredCommand == null) {
            return List.of();
        }
        if (args.length == 0) {
            args = new String[]{};
        }
        return registeredCommand.getCommandBranchProcessor().handleTabCompletion(registeredCommand, commandName, args, sender, 0).stream().toList();
    }

    public boolean handle(Sender sender, String commandName, String[] args) throws Throwable {
        RegisteredCommand registeredCommand = this.commandMap.get(commandName.toLowerCase());
        if (registeredCommand == null) {
            throw new UnknownCommandResponse(commandName).getError();
        }
        CommandContext context = registeredCommand.getCommandBranchProcessor().handle(registeredCommand, commandName, args, sender, 0);
        if (context == null) {
            BadCommandResponse badCommandResponse = null;
            for (RegisteredCommand.RegisteredCommandNode listener : registeredCommand.getCommands()) {
                RequirementResult requirementResult = listener.requirements().meetsRequirements(new RequirementEvaluationContext(sender, commandName, args, 0));
                if (!requirementResult.hasError()) continue;
                badCommandResponse = requirementResult.getError();
                break;
            }
            for (RegisteredCommand.RegisteredCommandNode listener : registeredCommand.getCommands()) {
                if (!listener.listener().fallbackHandle(sender, commandName, args)) continue;
                return true;
            }
            if (badCommandResponse != null) {
                if (this.handleError(null, sender, commandName, args, registeredCommand, context.error().getError())) {
                    return true;
                }
                context.error().throwError();
                return false;
            }
            return false;
        }
        if (context.hasError()) {
            if (this.handleError(context, sender, commandName, args, registeredCommand, context.error().getError())) {
                return true;
            }
            context.error().throwError();
            return false;
        }
        for (RegisteredCommandVariant method : context.option().getRegisteredCommandVariants()) {
            try {
                if (!this.invoke(context, sender, method)) continue;
                return true;
            }
            catch (Throwable e) {
                if (this.handleError(context, sender, commandName, args, registeredCommand, e)) {
                    return true;
                }
                throw e;
            }
        }
        for (RegisteredCommand.RegisteredCommandNode listener : registeredCommand.getCommands()) {
            if (!listener.listener().fallbackHandle(sender, commandName, args)) continue;
            return true;
        }
        return false;
    }

    private boolean handleError(CommandContext context, Sender sender, String commandName, String[] args, RegisteredCommand registeredCommand, Throwable error) {
        for (HandleExceptionVariant handleExceptionVariant : registeredCommand.getHandleExceptionVariants()) {
            if (!this.invokeException(handleExceptionVariant, context, sender, commandName, args, error)) continue;
            return true;
        }
        for (RegisteredCommand.RegisteredCommandNode listener : registeredCommand.getCommands()) {
            if (!listener.listener().handleException(sender, commandName, args, error)) continue;
            return true;
        }
        for (RegisteredCommand.RegisteredCommandNode listener : registeredCommand.getCommands()) {
            if (!listener.listener().fallbackHandle(sender, commandName, args)) continue;
            return true;
        }
        return false;
    }

    private boolean invokeException(HandleExceptionVariant handleExceptionVariant, CommandContext context, Sender sender, String commandName, String[] args, Throwable throwable) {
        Object output;
        List<Object> parameters = this.exceptionArgumentMapper.map(handleExceptionVariant, context, sender, commandName, args, throwable);
        if (parameters == null) {
            return false;
        }
        try {
            output = handleExceptionVariant.method().invokeWithArguments(parameters);
        }
        catch (Throwable e) {
            Dispensers.dispense(e);
            return false;
        }
        if (output != null && output.getClass().equals(Boolean.class)) {
            return (Boolean)output;
        }
        return true;
    }

    private boolean invoke(CommandContext context, Sender sender, RegisteredCommandVariant registeredCommandVariant) {
        Object output;
        ArrayList<Object> parameters = new ArrayList<Object>(registeredCommandVariant.argumentIndexList().stream().map(argumentIndex -> argumentIndex.get(context.toArgumentContext())).toList());
        parameters.add(0, registeredCommandVariant.commandNode());
        for (int i = 0; i < registeredCommandVariant.parameters().length; ++i) {
            Object obj = parameters.get(i + 1);
            for (ArgumentRequirement argumentRequirement : registeredCommandVariant.parameters()[i].argumentRequirements()) {
                if (argumentRequirement.meetsRequirement(sender, context, obj)) continue;
                return false;
            }
        }
        try {
            output = registeredCommandVariant.method().invokeWithArguments(parameters);
        }
        catch (Throwable e) {
            Dispensers.dispense(e);
            return false;
        }
        if (output != null && output.getClass().equals(Boolean.class)) {
            return (Boolean)output;
        }
        return true;
    }

    public void addCommand(CommandNode commandNode) {
        if (commandNode == null) {
            return;
        }
        Class<?> c = commandNode.getClass();
        if (c.isAnnotation()) {
            return;
        }
        Command handler = c.getAnnotation(Command.class);
        if (handler == null) {
            return;
        }
        RegisteredCommand registeredCommand = this.commandMap.computeIfAbsent(handler.value().toLowerCase(), cmd -> new RegisteredCommand(this));
        registeredCommand.addNode(commandNode);
        for (String alias : handler.aliases()) {
            this.commandMap.computeIfAbsent(alias.toLowerCase(), cmd -> new RegisteredCommand(this)).addNode(commandNode);
        }
        this.addCommand(commandNode, handler);
    }

    public CommandInfo getCommandInfo(String commandName) {
        RegisteredCommand registeredCommand = this.commandMap.get(commandName.toLowerCase());
        if (registeredCommand == null) {
            return null;
        }
        return registeredCommand.getCommandInfo();
    }

    protected abstract void addCommand(CommandNode var1, Command var2);

    public ArgumentMapper getArgumentMapper() {
        return this.argumentMapper;
    }

    public ExceptionArgumentMapper getExceptionArgumentMapper() {
        return this.exceptionArgumentMapper;
    }
}

