/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.apartium.cocoabeans.commands.Description;
import net.apartium.cocoabeans.commands.LongDescription;
import net.apartium.cocoabeans.commands.Usage;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.AvailableSince(value="0.0.30")
public class CommandInfo {
    private final List<Description> descriptions = new ArrayList<Description>();
    private final List<Usage> usages = new ArrayList<Usage>();
    private final List<LongDescription> longDescriptions = new ArrayList<LongDescription>();
    private Description description;
    private Usage usage;
    private LongDescription longDescription;

    public Optional<Description> getDescription() {
        if (this.descriptions.isEmpty()) {
            return Optional.empty();
        }
        if (this.description == null) {
            this.description = this.descriptions.get(0);
        }
        return Optional.of(this.description);
    }

    public Optional<Usage> getUsage() {
        if (this.usages.isEmpty()) {
            return Optional.empty();
        }
        if (this.usage == null) {
            this.usage = this.usages.get(0);
        }
        return Optional.of(this.usage);
    }

    public Optional<LongDescription> getLongDescription() {
        if (this.longDescriptions.isEmpty()) {
            return Optional.empty();
        }
        if (this.longDescription == null) {
            this.longDescription = this.longDescriptions.get(0);
        }
        return Optional.of(this.longDescription);
    }

    public List<Description> getDescriptions() {
        return Collections.unmodifiableList(this.descriptions);
    }

    public List<Usage> getUsages() {
        return Collections.unmodifiableList(this.usages);
    }

    public List<LongDescription> getLongDescriptions() {
        return Collections.unmodifiableList(this.longDescriptions);
    }

    void addDescription(Description description, boolean first) {
        if (first) {
            this.descriptions.add(0, description);
            return;
        }
        this.descriptions.add(description);
    }

    void addUsage(Usage usage, boolean first) {
        if (first) {
            this.usages.add(0, usage);
            return;
        }
        this.usages.add(usage);
    }

    void addLongDescription(LongDescription longDescription, boolean first) {
        if (first) {
            this.longDescriptions.add(0, longDescription);
            return;
        }
        this.longDescriptions.add(longDescription);
    }

    void fromAnnotations(Annotation[] annotations, boolean first) {
        for (Annotation annotation : annotations) {
            if (annotation instanceof Description) {
                Description description = (Description)annotation;
                this.addDescription(description, first);
                continue;
            }
            if (annotation instanceof Usage) {
                Usage usage = (Usage)annotation;
                this.addUsage(usage, first);
                continue;
            }
            if (!(annotation instanceof LongDescription)) continue;
            LongDescription longDescription = (LongDescription)annotation;
            this.addLongDescription(longDescription, first);
        }
    }

    void fromCommandInfo(CommandInfo other) {
        this.descriptions.addAll(other.descriptions);
        this.usages.addAll(other.usages);
        this.longDescriptions.addAll(other.longDescriptions);
    }
}

