/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.apartium.cocoabeans.commands.CommandContext;
import net.apartium.cocoabeans.commands.CommandManager;
import net.apartium.cocoabeans.commands.CommandOption;
import net.apartium.cocoabeans.commands.RegisteredCommand;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.exception.BadCommandResponse;
import net.apartium.cocoabeans.commands.requirements.RequirementEvaluationContext;
import net.apartium.cocoabeans.commands.requirements.RequirementResult;
import net.apartium.cocoabeans.commands.requirements.RequirementSet;
import net.apartium.cocoabeans.structs.Entry;
import org.jetbrains.annotations.Nullable;

class CommandBranchProcessor {
    private final CommandManager commandManager;
    final List<Entry<RequirementSet, CommandOption>> objectMap = new ArrayList<Entry<RequirementSet, CommandOption>>();

    CommandBranchProcessor(CommandManager commandManager) {
        this.commandManager = commandManager;
    }

    @Nullable
    CommandContext handle(RegisteredCommand commandWrapper, String commandName, String[] args, Sender sender, int index) {
        BadCommandResponse commandError = null;
        for (Entry<RequirementSet, CommandOption> entry : this.objectMap) {
            CommandOption commandOption = entry.value();
            if (commandOption == null) continue;
            RequirementResult requirementResult = entry.key().meetsRequirements(new RequirementEvaluationContext(sender, commandName, args, index));
            if (requirementResult.hasError()) {
                if (commandError != null && commandError.getDepth() >= requirementResult.getError().getDepth()) continue;
                commandError = requirementResult.getError();
                continue;
            }
            if (!requirementResult.meetRequirement()) continue;
            if (args.length <= index) {
                CommandContext commandContext;
                if (!entry.value().getOptionalArgumentTypeHandlerMap().isEmpty()) {
                    commandContext = entry.value().handleOptional(commandWrapper, commandName, args, sender, index);
                    if (commandContext == null) continue;
                    if (commandContext.hasError()) {
                        if (commandError != null && commandError.getDepth() >= commandContext.error().getDepth()) continue;
                        commandError = commandContext.error();
                        continue;
                    }
                    this.addToParserArgs(requirementResult, commandContext);
                    return commandContext;
                }
                if (entry.value().getRegisteredCommandVariants().isEmpty()) continue;
                commandContext = new CommandContext(sender, entry.value().getCommandInfo(), entry.value(), null, args, commandName, new HashMap());
                this.addToParserArgs(requirementResult, commandContext);
                return commandContext;
            }
            CommandContext result = commandOption.handle(commandWrapper, commandName, args, sender, index);
            if (result == null) continue;
            if (result.hasError()) {
                if (commandError != null && commandError.getDepth() >= result.error().getDepth()) continue;
                commandError = result.error();
                continue;
            }
            this.addToParserArgs(requirementResult, result);
            return result;
        }
        if (commandError != null) {
            return new CommandContext(sender, null, null, commandError, args, commandName, new HashMap());
        }
        return null;
    }

    private void addToParserArgs(RequirementResult requirementResult, CommandContext context) {
        for (RequirementResult.Value value : requirementResult.getValues()) {
            context.parsedArgs().computeIfAbsent(value.clazz(), clazz -> new ArrayList()).add(0, value.value());
        }
    }

    Set<String> handleTabCompletion(RegisteredCommand commandWrapper, String commandName, String[] args, Sender sender, int index) {
        if (args.length <= index) {
            return Set.of();
        }
        HashSet<String> result = new HashSet<String>();
        for (Entry<RequirementSet, CommandOption> entry : this.objectMap) {
            CommandOption commandOption = entry.value();
            if (commandOption == null || !entry.key().meetsRequirements(new RequirementEvaluationContext(sender, commandName, args, index)).meetRequirement()) continue;
            result.addAll(commandOption.handleTabCompletion(commandWrapper, commandName, args, sender, index));
        }
        return result;
    }

    boolean haveAnyRequirementsMeet(Sender sender, String commandName, String[] args, int depth) {
        for (Entry<RequirementSet, CommandOption> entry : this.objectMap) {
            CommandOption commandOption = entry.value();
            if (commandOption == null || !entry.key().meetsRequirements(new RequirementEvaluationContext(sender, commandName, args, depth)).meetRequirement()) continue;
            return true;
        }
        return false;
    }
}

