/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.commands;

import java.util.List;
import net.apartium.cocoabeans.commands.CommandProcessingContext;
import net.apartium.cocoabeans.commands.Sender;
import net.apartium.cocoabeans.commands.exception.BadCommandResponse;
import net.apartium.cocoabeans.commands.requirements.Requirement;
import net.apartium.cocoabeans.commands.requirements.RequirementEvaluationContext;
import net.apartium.cocoabeans.commands.requirements.RequirementResult;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
class AbstractCommandProcessingContext
implements CommandProcessingContext {
    @NotNull
    private final Sender sender;
    private final List<String> args;
    private final int index;
    private final String label;
    private BadCommandResponse error = null;

    AbstractCommandProcessingContext(@NotNull Sender sender, String label, String[] args, int index) {
        this.sender = sender;
        this.args = List.of(args);
        this.index = index;
        this.label = label;
    }

    @Override
    @NotNull
    public Sender sender() {
        return this.sender;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public List<String> args() {
        return this.args;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public RequirementResult senderMeetsRequirement(Requirement requirement) {
        return requirement.meetsRequirement(new RequirementEvaluationContext(this.sender, this.label, this.args.toArray(new String[0]), this.index));
    }

    @Override
    public void report(Object source, @NotNull BadCommandResponse response) {
        this.error = response;
    }

    public BadCommandResponse getReport() {
        return this.error;
    }

    public void clearReports() {
        this.error = null;
    }
}

