/*
 * Decompiled with CFR 0.152.
 */
package net.apartium.cocoabeans.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.jetbrains.annotations.NotNull;

public class WeightSet<E>
implements Set<E> {
    private double totalWeight;
    private final Map<E, Double> elements;

    public WeightSet() {
        this.totalWeight = 0.0;
        this.elements = new HashMap<E, Double>();
    }

    public WeightSet(WeightSet<E> weightSet) {
        this.totalWeight = weightSet.totalWeight;
        this.elements = new HashMap<E, Double>(weightSet.elements);
    }

    public WeightSet(Map<? extends E, ? extends Double> map) {
        this.elements = new HashMap<E, Double>(map);
        this.totalWeight = this.calculateWeight();
    }

    public OptionalDouble put(E element, double weight) {
        if (weight < 0.0) {
            throw new RuntimeException("Weight must be larger than 0");
        }
        Double oldWeight = this.elements.put(element, weight);
        this.totalWeight += weight;
        if (oldWeight == null || oldWeight.isNaN()) {
            return OptionalDouble.empty();
        }
        this.totalWeight -= oldWeight.doubleValue();
        return OptionalDouble.of(oldWeight);
    }

    public void putAll(Map<? extends E, ? extends Double> map) {
        this.elements.putAll(map);
        this.totalWeight = this.calculateWeight();
    }

    public void putAll(WeightSet<E> weightSet) {
        this.elements.putAll(weightSet.elements);
        this.totalWeight = this.calculateWeight();
    }

    @Override
    public void clear() {
        this.totalWeight = 0.0;
        this.elements.clear();
    }

    public OptionalDouble getWeight(E element) {
        Double val = this.elements.get(element);
        if (val == null || val.isNaN()) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(val);
    }

    public double getWeightOrDefault(E element, double defaultValue) {
        return this.elements.getOrDefault(element, defaultValue);
    }

    public OptionalDouble getPercentage(E element) {
        Double weight = this.elements.get(element);
        if (weight != null && !weight.isNaN()) {
            return OptionalDouble.of(weight / this.totalWeight * 100.0);
        }
        return OptionalDouble.empty();
    }

    public Set<E> values() {
        return Collections.unmodifiableSet(this.elements.keySet());
    }

    public double totalWeight() {
        return this.totalWeight;
    }

    @Override
    public boolean remove(Object o) {
        Double value = this.elements.remove(o);
        if (value == null || value.isNaN()) {
            return false;
        }
        this.totalWeight -= value.doubleValue();
        return true;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.containsKey(o);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.elements.keySet().iterator();
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] toArray() {
        return this.elements.entrySet().toArray();
    }

    @Override
    @NotNull
    public <T> @NotNull T @NotNull [] toArray(T @NotNull [] ts) {
        return this.elements.keySet().toArray(ts);
    }

    @Override
    public boolean add(E element) {
        return this.put(element, 0.0).isEmpty();
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        return this.elements.keySet().containsAll(collection);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> collection) {
        if (collection instanceof WeightSet) {
            WeightSet weightSet = (WeightSet)collection;
            this.putAll((Map)((Object)weightSet));
            return true;
        }
        for (E element : collection) {
            this.put(element, 0.0);
        }
        return true;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        return this.elements.keySet().removeIf(element -> !collection.contains(element));
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        for (Object obj : collection) {
            this.remove(obj);
        }
        return true;
    }

    public E pickOne() {
        return this.pickOne(ThreadLocalRandom.current());
    }

    public E pickOne(Random random) {
        if (this.elements.size() == 0) {
            return null;
        }
        double target = random.nextDouble() * this.totalWeight;
        double count = 0.0;
        for (Map.Entry<E, Double> entry : this.elements.entrySet()) {
            if (!((count += entry.getValue().doubleValue()) >= target)) continue;
            return entry.getKey();
        }
        return null;
    }

    public WeightSet<E> pickMany(int num) {
        return this.pickMany(num, ThreadLocalRandom.current());
    }

    public WeightSet<E> pickMany(int num, Random random) {
        if (num <= 0) {
            throw new RuntimeException("Number of elements must be bigger than 0");
        }
        if (this.elements.size() < num) {
            throw new RuntimeException("Number of elements must be smaller/equals elements size");
        }
        if (this.elements.size() == num) {
            return new WeightSet<E>(this);
        }
        WeightSet result = new WeightSet();
        double total = this.totalWeight;
        ArrayList<E> list = new ArrayList<E>(this.values());
        for (int i = 0; i < num; ++i) {
            double count = 0.0;
            double target = random.nextDouble() * total;
            int index = 0;
            for (Object key : list) {
                if ((count += this.getWeight(key).orElse(0.0)) >= target) break;
                ++index;
            }
            Object element = list.remove(index);
            double weight = this.getWeight(element).orElse(0.0);
            total -= weight;
            result.put(element, weight);
        }
        return result;
    }

    private double calculateWeight() {
        double weight = 0.0;
        for (Double num : this.elements.values()) {
            if (num.isInfinite() || num.isNaN()) {
                throw new RuntimeException("Can't be infinity or nan");
            }
            weight += num.doubleValue();
        }
        return weight;
    }
}

