/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.task;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.cooldown.CooldownManager;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CooldownVisualsTask
extends BukkitRunnable {
    private final BuffedItems plugin;
    private final NamespacedKey nbtKey;
    private final Map<UUID, BossBar> activeBossBars = new HashMap<UUID, BossBar>();

    public CooldownVisualsTask(BuffedItems plugin) {
        this.plugin = plugin;
        this.nbtKey = new NamespacedKey((Plugin)plugin, "buffeditem_id");
    }

    public void run() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updateVisuals(player);
        }
    }

    private void updateVisuals(Player player) {
        BuffedItem buffedItem;
        String itemId;
        BuffedItem currentItem = null;
        ItemStack handItem = player.getInventory().getItemInMainHand();
        boolean showVisuals = false;
        double remaining = 0.0;
        double maxCooldown = 1.0;
        boolean useActionBar = false;
        boolean useBossBar = false;
        String bbColorStr = "RED";
        String bbStyleStr = "SOLID";
        if (handItem != null && handItem.hasItemMeta() && (itemId = (String)handItem.getItemMeta().getPersistentDataContainer().get(this.nbtKey, PersistentDataType.STRING)) != null && (buffedItem = this.plugin.getItemManager().getBuffedItem(itemId)) != null && buffedItem.isActiveMode()) {
            CooldownManager cm = this.plugin.getCooldownManager();
            currentItem = buffedItem;
            if (cm.isOnCooldown(player, itemId)) {
                remaining = cm.getRemainingSeconds(player, itemId);
                maxCooldown = buffedItem.getCooldown();
                useActionBar = buffedItem.isVisualActionBar();
                useBossBar = buffedItem.isVisualBossBar();
                bbColorStr = buffedItem.getBossBarColor();
                bbStyleStr = buffedItem.getBossBarStyle();
                showVisuals = true;
            }
        }
        if (useActionBar && showVisuals) {
            String rawMsg = null;
            if (currentItem != null) {
                rawMsg = currentItem.getCustomActionBarMsg();
            }
            if (rawMsg == null) {
                rawMsg = this.plugin.getConfig().getString("active-items.messages.cooldown-action-bar", "&fCD: {time}s");
            }
            String timeMsg = rawMsg.replace("{time}", String.format("%.1f", remaining));
            String finalMsg = this.plugin.getHookManager().processPlaceholders((OfflinePlayer)player, timeMsg);
            player.sendActionBar(ConfigManager.fromLegacy(finalMsg));
        }
        UUID uuid = player.getUniqueId();
        if (useBossBar && showVisuals) {
            if (!this.activeBossBars.containsKey(uuid)) {
                BarStyle style;
                BarColor color;
                try {
                    color = BarColor.valueOf((String)bbColorStr);
                }
                catch (Exception e) {
                    color = BarColor.RED;
                }
                try {
                    style = BarStyle.valueOf((String)bbStyleStr);
                }
                catch (Exception e) {
                    style = BarStyle.SOLID;
                }
                BossBar bar = Bukkit.createBossBar((String)"Cooldown", (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
                bar.addPlayer(player);
                this.activeBossBars.put(uuid, bar);
            }
            bar = this.activeBossBars.get(uuid);
            try {
                bar.setColor(BarColor.valueOf((String)bbColorStr));
            }
            catch (Exception style) {
                // empty catch block
            }
            try {
                bar.setStyle(BarStyle.valueOf((String)bbStyleStr));
            }
            catch (Exception style) {
                // empty catch block
            }
            double progress = remaining / maxCooldown;
            if (progress < 0.0) {
                progress = 0.0;
            }
            if (progress > 1.0) {
                progress = 1.0;
            }
            bar.setProgress(progress);
            String rawTitle = null;
            if (currentItem != null) {
                rawTitle = currentItem.getCustomBossBarMsg();
            }
            if (rawTitle == null) {
                rawTitle = this.plugin.getConfig().getString("active-items.messages.cooldown-boss-bar", "CD: {time}s");
            }
            String timeTitle = rawTitle.replace("{time}", String.format("%.1f", remaining));
            String finalTitle = this.plugin.getHookManager().processPlaceholders((OfflinePlayer)player, timeTitle);
            bar.setTitle(ConfigManager.toSection(ConfigManager.fromLegacy(finalTitle)));
        } else if (this.activeBossBars.containsKey(uuid)) {
            bar = this.activeBossBars.get(uuid);
            bar.removePlayer(player);
            this.activeBossBars.remove(uuid);
            ConfigManager.sendDebugMessage(4, () -> "[CooldownVisuals] Removed BossBar for player: " + player.getName());
        }
    }

    public void cleanup() {
        for (BossBar bar : this.activeBossBars.values()) {
            try {
                bar.removeAll();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error removing BossBar during cleanup: " + e.getMessage());
            }
        }
        this.activeBossBars.clear();
        ConfigManager.sendDebugMessage(1, () -> "[CooldownVisuals] Cleaned up all BossBars during shutdown");
    }
}

