/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.upgrade;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.UpgradesConfig;
import io.github.altkat.BuffedItems.manager.cost.ICost;
import io.github.altkat.BuffedItems.manager.cost.types.BuffedItemCost;
import io.github.altkat.BuffedItems.manager.upgrade.FailureAction;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.selector.BuffedItemSelectorMenu;
import io.github.altkat.BuffedItems.menu.upgrade.IngredientListMenu;
import io.github.altkat.BuffedItems.menu.upgrade.UpgradeRecipeListMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import java.util.ArrayList;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class UpgradeRecipeEditorMenu
extends Menu {
    private final BuffedItems plugin;
    private final String recipeId;

    public UpgradeRecipeEditorMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.recipeId = playerMenuUtility.getItemToEditId();
    }

    @Override
    public String getMenuName() {
        return "Editing: " + this.recipeId;
    }

    @Override
    public int getSlots() {
        return 27;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        switch (e.getSlot()) {
            case 10: {
                this.askInput(p, "upgrade.display_name", "\u00a7aEnter new Display Name (Color codes and hex colors supported).");
                break;
            }
            case 11: {
                this.askInput(p, "upgrade.success_rate", "\u00a7aEnter Success Rate (0-100).");
                break;
            }
            case 12: {
                FailureAction currentAction;
                String path = "upgrades." + this.recipeId + ".failure_action";
                String currentStr = UpgradesConfig.get().getString(path, "LOSE_EVERYTHING");
                try {
                    currentAction = FailureAction.valueOf(currentStr);
                }
                catch (Exception ex) {
                    currentAction = FailureAction.LOSE_EVERYTHING;
                }
                ConfigManager.setUpgradeValue(this.recipeId, "failure_action", (switch (currentAction) {
                    case FailureAction.LOSE_EVERYTHING -> FailureAction.KEEP_BASE_ONLY;
                    case FailureAction.KEEP_BASE_ONLY -> FailureAction.KEEP_EVERYTHING;
                    default -> FailureAction.LOSE_EVERYTHING;
                }).name());
                this.open();
                break;
            }
            case 13: {
                new BuffedItemSelectorMenu(this.playerMenuUtility, this.plugin, BuffedItemSelectorMenu.SelectionContext.BASE).open();
                break;
            }
            case 14: {
                new IngredientListMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 15: {
                new BuffedItemSelectorMenu(this.playerMenuUtility, this.plugin, BuffedItemSelectorMenu.SelectionContext.RESULT).open();
                break;
            }
            case 16: {
                this.askInput(p, "upgrade.result.amount", "\u00a7aEnter Result Amount.");
                break;
            }
            case 22: {
                new UpgradeRecipeListMenu(this.playerMenuUtility, this.plugin).open();
            }
        }
    }

    private void askInput(Player p, String path, String msg) {
        this.playerMenuUtility.setWaitingForChatInput(true);
        this.playerMenuUtility.setChatInputPath(path);
        p.closeInventory();
        p.sendMessage(ConfigManager.fromSectionWithPrefix(msg));
        p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
    }

    @Override
    public void setMenuItems() {
        String actionDesc;
        String actionName;
        Material iconMat;
        FailureAction fAction;
        this.setFillerGlass();
        String path = "upgrades." + this.recipeId;
        String displayName = UpgradesConfig.get().getString(path + ".display_name", "Unknown");
        double successRate = UpgradesConfig.get().getDouble(path + ".success_rate", 100.0);
        String resultItemId = UpgradesConfig.get().getString(path + ".result.item", "None");
        int resultAmount = UpgradesConfig.get().getInt(path + ".result.amount", 1);
        Object resultDisplayName = "\u00a7f" + resultItemId;
        BuffedItem resultItem = this.plugin.getItemManager().getBuffedItem(resultItemId);
        if (resultItem != null) {
            resultDisplayName = ConfigManager.toSection(ConfigManager.fromLegacy(resultItem.getDisplayName()));
        }
        Object baseDisplayName = "\u00a7cNone";
        Object baseIdDisplay = "";
        if (UpgradesConfig.get().contains(path + ".base")) {
            String bId;
            ICost baseCost = null;
            if (UpgradesConfig.get().isString(path + ".base")) {
                bId = UpgradesConfig.get().getString(path + ".base");
                HashMap<String, Object> syntheticMap = new HashMap<String, Object>();
                syntheticMap.put("type", "BUFFED_ITEM");
                syntheticMap.put("amount", 1);
                syntheticMap.put("item_id", bId);
                baseCost = this.plugin.getCostManager().parseCost(syntheticMap);
            }
            if (baseCost != null) {
                baseDisplayName = "\u00a7f" + baseCost.getDisplayString();
                if (baseCost instanceof BuffedItemCost) {
                    bId = ((BuffedItemCost)baseCost).getRequiredItemId();
                    BuffedItem bItem = this.plugin.getItemManager().getBuffedItem(bId);
                    baseDisplayName = bItem != null ? ConfigManager.toSection(ConfigManager.fromLegacy(bItem.getDisplayName())) : "\u00a7f" + bId;
                    baseIdDisplay = "\u00a78(ID: " + bId + ")";
                }
            }
        }
        int ingCount = UpgradesConfig.get().getMapList(path + ".ingredients").size();
        this.inventory.setItem(10, this.makeItem(Material.NAME_TAG, "\u00a7eDisplay Name", "\u00a77Current: \u00a7r" + ConfigManager.toSection(ConfigManager.fromLegacy(displayName)), "", "\u00a7aClick to Edit"));
        this.inventory.setItem(11, this.makeItem(Material.DIAMOND, "\u00a7bSuccess Rate", "\u00a77Current: \u00a7e" + successRate + "%", "", "\u00a7aClick to Edit"));
        String failPath = "upgrades." + this.recipeId + ".failure_action";
        String failStr = UpgradesConfig.get().getString(failPath, "LOSE_EVERYTHING");
        try {
            fAction = FailureAction.valueOf(failStr);
        }
        catch (Exception e) {
            fAction = FailureAction.LOSE_EVERYTHING;
        }
        if (fAction == FailureAction.KEEP_EVERYTHING) {
            iconMat = Material.TOTEM_OF_UNDYING;
            actionName = "\u00a7aKeep Everything";
            actionDesc = "\u00a77Nothing is lost on failure.";
        } else if (fAction == FailureAction.KEEP_BASE_ONLY) {
            iconMat = Material.IRON_CHESTPLATE;
            actionName = "\u00a7eKeep Base Item";
            actionDesc = "\u00a77Ingredients lost, Item kept.";
        } else {
            iconMat = Material.SKELETON_SKULL;
            actionName = "\u00a7cLose Everything";
            actionDesc = "\u00a77Item and ingredients lost.";
        }
        this.inventory.setItem(12, this.makeItem(iconMat, "\u00a76Failure Action", "\u00a77Current: " + actionName, actionDesc, "", "\u00a7eClick to Cycle", "\u00a78(Lose All -> Keep Base -> Keep All)"));
        ArrayList<Object> baseLore = new ArrayList<Object>();
        baseLore.add("\u00a77Current: " + (String)baseDisplayName);
        if (!((String)baseIdDisplay).isEmpty()) {
            baseLore.add(baseIdDisplay);
        }
        baseLore.add("");
        baseLore.add("\u00a7eClick to Select (Input Item)");
        this.inventory.setItem(13, this.makeItem(Material.ANVIL, "\u00a7aSet Base Item", baseLore.toArray(new String[0])));
        this.inventory.setItem(14, this.makeItem(Material.HOPPER, "\u00a7bManage Ingredients", "\u00a77Current: \u00a7e" + ingCount + " costs", "", "\u00a7eClick to Edit List"));
        this.inventory.setItem(15, this.makeItem(Material.CHEST, "\u00a7dResult Item", "\u00a77Current: " + (String)resultDisplayName, "\u00a78(ID: " + resultItemId + ")", "", "\u00a7aClick to Select"));
        this.inventory.setItem(16, this.makeItem(Material.GOLD_NUGGET, "\u00a76Result Amount", "\u00a77Current: \u00a7e" + resultAmount, "", "\u00a7aClick to Edit"));
        this.inventory.setItem(22, this.makeItem(Material.BARRIER, "\u00a7cBack", new String[0]));
    }
}

