/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.set;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.set.SetBonusesMenu;
import io.github.altkat.BuffedItems.menu.set.SetItemsMenu;
import io.github.altkat.BuffedItems.menu.set.SetListMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.set.BuffedSet;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class SetEditorMenu
extends Menu {
    private final BuffedItems plugin;
    private final String setId;

    public SetEditorMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.setId = playerMenuUtility.getItemToEditId();
    }

    @Override
    public String getMenuName() {
        return "Edit Set: " + this.setId;
    }

    @Override
    public int getSlots() {
        return 27;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        switch (e.getSlot()) {
            case 11: {
                this.playerMenuUtility.setWaitingForChatInput(true);
                this.playerMenuUtility.setChatInputPath("set_display_name");
                p.closeInventory();
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter new Display Name for the set."));
                p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
                break;
            }
            case 13: {
                new SetItemsMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 15: {
                new SetBonusesMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 22: {
                new SetListMenu(this.playerMenuUtility, this.plugin).open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.setFillerGlass();
        BuffedSet set = this.plugin.getSetManager().getSet(this.setId);
        if (set == null) {
            this.inventory.setItem(13, this.makeItem(Material.BARRIER, "\u00a7cError", "\u00a77Set not found."));
            return;
        }
        this.inventory.setItem(11, this.makeItem(Material.NAME_TAG, "\u00a7eDisplay Name", "\u00a77Current: " + ConfigManager.toSection(ConfigManager.fromLegacy(set.getDisplayName())), "", "\u00a7aClick to Edit"));
        this.inventory.setItem(13, this.makeItem(Material.DIAMOND_CHESTPLATE, "\u00a7bManage Items", "\u00a77Add or remove items", "\u00a77from this set.", "", "\u00a77Count: \u00a7f" + set.getItemIds().size(), "", "\u00a7eClick to Manage"));
        this.inventory.setItem(15, this.makeItem(Material.ENCHANTING_TABLE, "\u00a7dManage Bonuses", "\u00a77Configure effects gained", "\u00a77by wearing set pieces.", "", "\u00a77Tiers: \u00a7f" + set.getBonuses().size(), "", "\u00a7eClick to Manage"));
        this.inventory.setItem(22, this.makeItem(Material.BARRIER, "\u00a7cBack", new String[0]));
    }
}

