/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.selector;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.RecipesConfig;
import io.github.altkat.BuffedItems.manager.config.SetsConfig;
import io.github.altkat.BuffedItems.menu.active.CostListMenu;
import io.github.altkat.BuffedItems.menu.active.UsageLimitSettingsMenu;
import io.github.altkat.BuffedItems.menu.base.PaginatedMenu;
import io.github.altkat.BuffedItems.menu.crafting.IngredientSettingsMenu;
import io.github.altkat.BuffedItems.menu.crafting.RecipeEditorMenu;
import io.github.altkat.BuffedItems.menu.set.SetItemsMenu;
import io.github.altkat.BuffedItems.menu.upgrade.IngredientListMenu;
import io.github.altkat.BuffedItems.menu.upgrade.UpgradeRecipeEditorMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BuffedItemSelectorMenu
extends PaginatedMenu {
    private final BuffedItems plugin;
    private final SelectionContext context;
    private final List<BuffedItem> items;

    public BuffedItemSelectorMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin, SelectionContext context) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.context = context;
        this.items = new ArrayList<BuffedItem>(plugin.getItemManager().getLoadedItems().values());
        this.items.sort(Comparator.comparing(BuffedItem::getId));
        this.maxItemsPerPage = 36;
    }

    @Override
    public String getMenuName() {
        return "Select Item (" + this.context.name() + ")";
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        if (this.handlePageChange(e, this.items.size())) {
            return;
        }
        if (e.getSlot() == 49 && e.getCurrentItem().getType() == Material.PAPER) {
            this.handleManualInput(p);
            return;
        }
        if (e.getSlot() == 53 && e.getCurrentItem().getType() == Material.BARRIER) {
            this.handleBack();
            return;
        }
        if (e.getSlot() >= 9 && e.getSlot() < 45) {
            int index = this.maxItemsPerPage * this.page + (e.getSlot() - 9);
            if (index >= this.items.size()) {
                return;
            }
            BuffedItem selectedItem = this.items.get(index);
            this.handleSelection(p, selectedItem.getId());
        }
    }

    private void handleSelection(Player p, String itemId) {
        switch (this.context.ordinal()) {
            case 2: {
                ConfigManager.setUpgradeValue(this.playerMenuUtility.getItemToEditId(), "base", itemId);
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aBase item updated to: \u00a7e" + itemId));
                new UpgradeRecipeEditorMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 3: {
                ConfigManager.setUpgradeValue(this.playerMenuUtility.getItemToEditId(), "result.item", itemId);
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aResult item updated to: \u00a7e" + itemId));
                new UpgradeRecipeEditorMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 1: {
                this.playerMenuUtility.setTempId(itemId);
                this.playerMenuUtility.setWaitingForChatInput(true);
                this.playerMenuUtility.setChatInputPath("upgrade.ingredients.add.BUFFED_ITEM_QUANTITY");
                p.closeInventory();
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aSelected Item: \u00a7e" + itemId));
                p.sendMessage(ConfigManager.fromSection("\u00a7aPlease enter the Amount (Quantity) in chat."));
                p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
                break;
            }
            case 0: {
                this.playerMenuUtility.setTempId(itemId);
                this.playerMenuUtility.setWaitingForChatInput(true);
                this.playerMenuUtility.setChatInputPath("active.costs.add.BUFFED_ITEM_QUANTITY");
                p.closeInventory();
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aSelected Item: \u00a7e" + itemId));
                p.sendMessage(ConfigManager.fromSection("\u00a7aPlease enter the Amount (Quantity) in chat."));
                p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
                break;
            }
            case 4: {
                ConfigManager.setItemValue(this.playerMenuUtility.getItemToEditId(), "usage-limit.transform-item", itemId);
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aTransform Target updated to: \u00a7e" + itemId));
                new UsageLimitSettingsMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 5: {
                String setId = this.playerMenuUtility.getItemToEditId();
                List items = SetsConfig.get().getStringList("sets." + setId + ".items");
                if (items.contains(itemId)) {
                    p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7cItem already in set."));
                } else {
                    items.add(itemId);
                    SetsConfig.get().set("sets." + setId + ".items", (Object)items);
                    SetsConfig.save();
                    this.plugin.getSetManager().loadSets(true);
                    p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aAdded " + itemId + " to set."));
                }
                new SetItemsMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 6: {
                String recipeId = this.playerMenuUtility.getRecipeToEditId();
                RecipesConfig.get().set("recipes." + recipeId + ".result.item", (Object)itemId);
                this.playerMenuUtility.setUnsavedChanges(true);
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aRecipe result updated to: \u00a7e" + itemId));
                new RecipeEditorMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 7: {
                this.playerMenuUtility.setTempId(itemId);
                new IngredientSettingsMenu(this.playerMenuUtility, this.plugin, true).open();
            }
        }
    }

    private void handleManualInput(Player p) {
        this.playerMenuUtility.setWaitingForChatInput(true);
        p.closeInventory();
        switch (this.context.ordinal()) {
            case 2: {
                this.playerMenuUtility.setChatInputPath("upgrade.base.set_id");
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter Base Item ID manually."));
                break;
            }
            case 3: {
                this.playerMenuUtility.setChatInputPath("upgrade.result.item");
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter Result Item ID manually."));
                break;
            }
            case 1: {
                this.playerMenuUtility.setChatInputPath("upgrade.ingredients.add.BUFFED_ITEM");
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter Buffed Item ID manually."));
                p.sendMessage(ConfigManager.fromSection("\u00a7eFormat: AMOUNT;ITEM_ID"));
                break;
            }
            case 0: {
                this.playerMenuUtility.setChatInputPath("active.costs.add.BUFFED_ITEM");
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter Buffed Item ID manually."));
                p.sendMessage(ConfigManager.fromSection("\u00a7eFormat: AMOUNT;ITEM_ID"));
                break;
            }
            case 4: {
                this.playerMenuUtility.setChatInputPath("usage-limit.transform-item");
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter Target Buffed Item ID manually."));
                break;
            }
            case 6: {
                this.playerMenuUtility.setChatInputPath("recipe_result_manual");
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter Result Buffed Item ID manually."));
                break;
            }
            case 7: {
                this.playerMenuUtility.setChatInputPath("recipe_ingredient_buffed_manual");
                this.playerMenuUtility.setUnsavedChanges(true);
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter Buffed Item ID manually."));
            }
        }
        p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
    }

    private void handleBack() {
        switch (this.context.ordinal()) {
            case 2: 
            case 3: {
                new UpgradeRecipeEditorMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 1: {
                new IngredientListMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 0: {
                new CostListMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 4: {
                new UsageLimitSettingsMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 5: {
                new SetItemsMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 6: {
                new RecipeEditorMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case 7: {
                new IngredientSettingsMenu(this.playerMenuUtility, this.plugin, false).open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        int index;
        int i;
        ItemStack filler = this.makeItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]);
        for (i = 0; i < 9; ++i) {
            this.inventory.setItem(i, filler);
        }
        for (i = 45; i < 54; ++i) {
            this.inventory.setItem(i, filler);
        }
        this.addMenuControls();
        this.inventory.setItem(49, this.makeItem(Material.PAPER, "\u00a7eManual Input", "\u00a77Click to type ID in chat manually."));
        this.inventory.setItem(53, this.makeItem(Material.BARRIER, "\u00a7cBack", new String[0]));
        for (i = 0; i < this.maxItemsPerPage && (index = this.maxItemsPerPage * this.page + i) < this.items.size(); ++i) {
            BuffedItem item = this.items.get(index);
            ItemStack stack = new ItemBuilder(item, (Plugin)this.plugin).build();
            ItemMeta meta = stack.getItemMeta();
            if (meta != null) {
                ArrayList<TextComponent> lore = meta.lore();
                if (lore == null) {
                    lore = new ArrayList<TextComponent>();
                }
                lore.add(Component.empty());
                lore.add((TextComponent)ConfigManager.fromSection("\u00a77ID: \u00a7f" + item.getId()));
                lore.add(Component.empty());
                lore.add((TextComponent)ConfigManager.fromSection("\u00a7eClick to select"));
                meta.lore(lore);
                stack.setItemMeta(meta);
            }
            this.inventory.setItem(9 + i, stack);
        }
    }

    public static enum SelectionContext {
        COST,
        INGREDIENT,
        BASE,
        RESULT,
        USAGE_LIMIT,
        SET_MEMBER,
        CRAFTING_RESULT,
        CRAFTING_INGREDIENT;

    }
}

