/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.editor;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.editor.ItemEditorMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class PermissionSettingsMenu
extends Menu {
    private final BuffedItems plugin;
    private final String itemId;

    public PermissionSettingsMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.itemId = playerMenuUtility.getItemToEditId();
    }

    @Override
    public String getMenuName() {
        return "Permissions: " + this.itemId;
    }

    @Override
    public int getSlots() {
        return 27;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        Material type = e.getCurrentItem().getType();
        if (type == Material.BARRIER) {
            new ItemEditorMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        String inputPath = null;
        String title = "";
        switch (e.getSlot()) {
            case 11: {
                inputPath = "permission";
                title = "Main Permission";
                break;
            }
            case 13: {
                inputPath = "active_permission";
                title = "Active Permission (Override)";
                break;
            }
            case 15: {
                inputPath = "passive_permission";
                title = "Passive Permission (Override)";
            }
        }
        if (inputPath != null) {
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath(inputPath);
            p.closeInventory();
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter the " + title + " in chat."));
            p.sendMessage(ConfigManager.fromSection("\u00a77Type 'none' to remove/inherit."));
            p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit."));
        }
    }

    @Override
    public void setMenuItems() {
        this.setFillerGlass();
        this.addBackButton(new ItemEditorMenu(this.playerMenuUtility, this.plugin));
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.itemId);
        if (item == null) {
            return;
        }
        String perm = item.getPermission();
        String mainPerm = perm != null ? perm : "NONE";
        String activePerm = item.getActivePermissionRaw();
        String passivePerm = item.getPassivePermissionRaw();
        this.inventory.setItem(4, this.makeItem(Material.BOOK, "\u00a7bHow Permissions Work?", "\u00a77Simple explanation:", "", "\u00a7e1. Main Permission:", "\u00a77It controls both \u00a7fActive\u00a77 and \u00a7fPassive\u00a77.", "\u00a77If you set this, player needs it for everything.", "", "\u00a762. Specific Permissions:", "\u00a77You can set separate permissions for", "\u00a77\u00a7bActive\u00a77 (Right-Click) and \u00a7dPassive\u00a77 (Stats).", "\u00a77If set, they replace the Main Permission."));
        this.inventory.setItem(11, this.makeItem(Material.PAPER, "\u00a7eMain Permission", "\u00a77The base permission node.", "\u00a77Current: \u00a7f" + mainPerm, "", "\u00a7aClick to Edit"));
        ArrayList<Object> activeLore = new ArrayList<Object>();
        activeLore.add("\u00a77Required for active(Right-Click) abilities.");
        if (activePerm == null) {
            activeLore.add("\u00a77Current: \u00a78(Inherits Main)");
            activeLore.add("\u00a77Effective: \u00a7f" + mainPerm);
        } else {
            activeLore.add("\u00a77Current: \u00a7b" + activePerm);
            activeLore.add("\u00a77(Overrides Main)");
        }
        activeLore.add("");
        activeLore.add("\u00a7aClick to Edit");
        this.inventory.setItem(13, this.makeItem(Material.FISHING_ROD, "\u00a7bActive Permission (Override)", activeLore.toArray(new String[0])));
        ArrayList<Object> passiveLore = new ArrayList<Object>();
        passiveLore.add("\u00a77Required for passive attributes/effects.");
        if (passivePerm == null) {
            passiveLore.add("\u00a77Current: \u00a78(Inherits Main)");
            passiveLore.add("\u00a77Effective: \u00a7f" + mainPerm);
        } else {
            passiveLore.add("\u00a77Current: \u00a7d" + passivePerm);
            passiveLore.add("\u00a77(Overrides Main)");
        }
        passiveLore.add("");
        passiveLore.add("\u00a7e\u26a0 Attribute Mode Warning:");
        passiveLore.add("\u00a77Attribute restrictions ONLY");
        passiveLore.add("\u00a77work in \u00a7bDYNAMIC \u00a77mode.");
        passiveLore.add("\u00a77In \u00a7fSTATIC \u00a77mode, attributes");
        passiveLore.add("\u00a77are always active (NBT).");
        passiveLore.add("");
        passiveLore.add("\u00a77*Except \u00a7eINVENTORY \u00a77slot:");
        passiveLore.add("\u00a77 Attributes in inventory always");
        passiveLore.add("\u00a77 \u00a7aRESPECT \u00a77permission even in \u00a7fSTATIC \u00a77mode.");
        passiveLore.add("");
        passiveLore.add("\u00a7aClick to Edit");
        this.inventory.setItem(15, this.makeItem(Material.SHIELD, "\u00a7dPassive Permission (Override)", passiveLore.toArray(new String[0])));
    }
}

