/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.crafting;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.crafting.CustomRecipe;
import io.github.altkat.BuffedItems.manager.crafting.MatchType;
import io.github.altkat.BuffedItems.manager.crafting.RecipeIngredient;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.crafting.PublicRecipeListMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class RecipePreviewMenu
extends Menu {
    private final BuffedItems plugin;
    private final CustomRecipe recipe;

    public RecipePreviewMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin, CustomRecipe recipe) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.recipe = recipe;
    }

    @Override
    public String getMenuName() {
        return "Recipe View: " + this.recipe.getId();
    }

    @Override
    public int getSlots() {
        return 45;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        if (e.getSlot() == 40) {
            new PublicRecipeListMenu(this.playerMenuUtility, this.plugin).open();
        }
    }

    @Override
    public void setMenuItems() {
        ItemMeta meta;
        int[] gridSlots;
        this.setFillerGlass();
        for (int slot : gridSlots = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30}) {
            this.inventory.setItem(slot, new ItemStack(Material.AIR));
        }
        BuffedItem resultBi = this.plugin.getItemManager().getBuffedItem(this.recipe.getResultItemId());
        ItemStack resultIcon = resultBi != null ? new ItemBuilder(resultBi, (Plugin)this.plugin).build() : this.makeItem(Material.BARRIER, "\u00a7cUnknown Item", new String[0]);
        resultIcon.setAmount(this.recipe.getAmount());
        if (this.recipe.getAmount() > 1 && (meta = resultIcon.getItemMeta()) != null) {
            Component currentName = meta.hasDisplayName() ? meta.displayName() : ConfigManager.fromSection("\u00a7f" + this.formatMaterialName(resultIcon.getType()));
            Component amountPrefix = ConfigManager.fromSection("\u00a7e" + this.recipe.getAmount() + "x ");
            meta.displayName(amountPrefix.append(currentName));
            resultIcon.setItemMeta(meta);
        }
        this.inventory.setItem(25, resultIcon);
        this.inventory.setItem(23, this.makeItem(Material.ARROW, "\u00a7e->", new String[0]));
        List<String> shape = this.recipe.getShape();
        if (shape != null) {
            for (int row = 0; row < shape.size(); ++row) {
                String line = shape.get(row);
                for (int col = 0; col < line.length(); ++col) {
                    int slotIndex;
                    char key = line.charAt(col);
                    RecipeIngredient ing = this.recipe.getIngredient(key);
                    if (ing == null || (slotIndex = row * 3 + col) >= gridSlots.length) continue;
                    ItemStack ingredientIcon = this.getIngredientIcon(ing);
                    this.inventory.setItem(gridSlots[slotIndex], ingredientIcon);
                }
            }
        }
        this.inventory.setItem(40, this.makeItem(Material.BARRIER, "\u00a7cBack to List", new String[0]));
    }

    private ItemStack getIngredientIcon(RecipeIngredient ing) {
        ItemStack icon = new ItemStack(Material.BARRIER);
        if (ing.getMatchType() == MatchType.BUFFED_ITEM) {
            BuffedItem bi = this.plugin.getItemManager().getBuffedItem(ing.getData());
            if (bi != null) {
                icon = new ItemBuilder(bi, (Plugin)this.plugin).build();
            }
        } else if (ing.getMatchType() == MatchType.EXACT) {
            if (ing.getExactReferenceItem() != null) {
                icon = ing.getExactReferenceItem().clone();
            }
        } else {
            Material mat = ing.getMaterial() != null ? ing.getMaterial() : Material.BEDROCK;
            icon = new ItemStack(mat);
        }
        icon.setAmount(ing.getAmount());
        ItemMeta meta = icon.getItemMeta();
        if (meta != null) {
            Component displayName = ing.getMatchType() == MatchType.MATERIAL || !meta.hasDisplayName() ? ConfigManager.fromSection("\u00a7f" + this.formatMaterialName(icon.getType())) : meta.displayName();
            if (ing.getAmount() > 1) {
                Component amountPrefix = ConfigManager.fromSection("\u00a7e" + ing.getAmount() + "x ");
                displayName = amountPrefix.append(displayName);
            }
            meta.displayName(displayName);
            ArrayList<Object> lore = meta.hasLore() ? new ArrayList<Object>(meta.lore()) : new ArrayList();
            lore.add(Component.empty());
            lore.add(ConfigManager.fromSection("\u00a77Required Amount: \u00a7e" + ing.getAmount()));
            meta.lore(lore);
            icon.setItemMeta(meta);
        }
        return icon;
    }

    private String formatMaterialName(Material material) {
        String name = material.name().toLowerCase().replace("_", " ");
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

