/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.crafting;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.RecipesConfig;
import io.github.altkat.BuffedItems.manager.crafting.MatchType;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.crafting.IngredientSettingsMenu;
import io.github.altkat.BuffedItems.menu.crafting.RecipeListMenu;
import io.github.altkat.BuffedItems.menu.selector.BuffedItemSelectorMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.Serializer;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class RecipeEditorMenu
extends Menu {
    private final BuffedItems plugin;
    private final String recipeId;
    private final int[] gridSlots = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30};
    private final int RESULT_SLOT = 24;

    public RecipeEditorMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.recipeId = playerMenuUtility.getRecipeToEditId();
    }

    @Override
    public String getMenuName() {
        return "Edit Recipe: " + this.recipeId;
    }

    @Override
    public int getSlots() {
        return 54;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        for (int i = 0; i < this.gridSlots.length; ++i) {
            if (e.getSlot() != this.gridSlots[i]) continue;
            this.playerMenuUtility.setSelectedRecipeSlot(i);
            new IngredientSettingsMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (e.getSlot() == 24) {
            new BuffedItemSelectorMenu(this.playerMenuUtility, this.plugin, BuffedItemSelectorMenu.SelectionContext.CRAFTING_RESULT).open();
            return;
        }
        if (e.getSlot() == 33) {
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath("recipe_result_amount");
            p.closeInventory();
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter result amount in chat."));
            return;
        }
        if (e.getSlot() == 50) {
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath("recipe_permission");
            p.closeInventory();
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter permission node (or 'none' to remove)."));
            p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit)"));
            return;
        }
        if (e.getSlot() == 49) {
            boolean current = RecipesConfig.get().getBoolean("recipes." + this.recipeId + ".enabled", true);
            RecipesConfig.get().set("recipes." + this.recipeId + ".enabled", (Object)(!current ? 1 : 0));
            this.playerMenuUtility.setUnsavedChanges(true);
            this.open();
            return;
        }
        if (e.getSlot() == 53) {
            if (this.playerMenuUtility.hasUnsavedChanges()) {
                RecipesConfig.save();
                this.plugin.getCraftingManager().loadRecipes(true);
                this.playerMenuUtility.setUnsavedChanges(false);
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aChanges saved successfully."));
            }
            new RecipeListMenu(this.playerMenuUtility, this.plugin).open();
        }
    }

    @Override
    public void setMenuItems() {
        BuffedItem resultItem;
        this.setFillerGlass();
        ConfigurationSection section = RecipesConfig.get().getConfigurationSection("recipes." + this.recipeId);
        if (section == null) {
            this.inventory.setItem(22, this.makeItem(Material.BARRIER, "\u00a7cError", "\u00a77Recipe path not found in config!"));
            return;
        }
        ConfigurationSection ingredientsSec = section.getConfigurationSection("ingredients");
        for (int i = 0; i < 9; ++i) {
            int slot = this.gridSlots[i];
            char key = (char)(65 + i);
            if (ingredientsSec != null && ingredientsSec.contains(String.valueOf(key))) {
                ConfigurationSection ingSec = ingredientsSec.getConfigurationSection(String.valueOf(key));
                if (ingSec != null) {
                    this.inventory.setItem(slot, this.getIngredientIconFromConfig(ingSec));
                    continue;
                }
                this.inventory.setItem(slot, this.makeItem(Material.LIGHT_GRAY_STAINED_GLASS_PANE, "\u00a77Empty Slot", "\u00a7eClick to Set"));
                continue;
            }
            this.inventory.setItem(slot, this.makeItem(Material.LIGHT_GRAY_STAINED_GLASS_PANE, "\u00a77Empty Slot", "\u00a7eClick to Set"));
        }
        String resultId = section.getString("result.item");
        int amount = section.getInt("result.amount", 1);
        String permission = section.getString("permission", "None");
        boolean isTableEnabled = section.getBoolean("enabled", true);
        ItemStack resultStack = resultId != null ? ((resultItem = this.plugin.getItemManager().getBuffedItem(resultId)) != null ? new ItemBuilder(resultItem, (Plugin)this.plugin).build() : this.makeItem(Material.BARRIER, "\u00a7cUnknown ID", "\u00a77" + resultId)) : this.makeItem(Material.BARRIER, "\u00a7cSelect Result", "\u00a77Click to choose output item.");
        ItemMeta meta = resultStack.getItemMeta();
        if (resultStack.getType().getMaxStackSize() == 1 && amount > 1) {
            String originalName = meta.hasDisplayName() ? meta.getDisplayName() : this.formatMaterialName(resultStack.getType());
            meta.displayName(ConfigManager.fromSection("\u00a7e" + amount + "x " + originalName));
        }
        ArrayList<Object> lore = meta.hasLore() ? new ArrayList<Object>(meta.lore()) : new ArrayList();
        lore.add(Component.empty());
        lore.add(ConfigManager.fromSection("\u00a77Amount: \u00a7e" + amount));
        lore.add(ConfigManager.fromSection("\u00a7eClick to Change Result"));
        meta.lore(lore);
        resultStack.setItemMeta(meta);
        resultStack.setAmount(Math.max(1, amount));
        this.inventory.setItem(24, resultStack);
        this.inventory.setItem(33, this.makeItem(Material.GOLD_NUGGET, "\u00a76Result Amount", "\u00a77Current: \u00a7e" + amount, "", "\u00a7aClick to Edit"));
        this.inventory.setItem(50, this.makeItem(Material.PAPER, "\u00a7eRecipe Permission", "\u00a77Current: \u00a7f" + (permission == null ? "None" : permission), "", "\u00a7aClick to Edit"));
        this.inventory.setItem(22, this.makeItem(Material.CRAFTING_TABLE, "\u00a7eCrafting Grid", "\u00a77Configure the 3x3 pattern."));
        this.inventory.setItem(23, this.makeItem(Material.ARROW, "\u00a77->", new String[0]));
        ItemStack tableIcon = isTableEnabled ? this.makeItem(Material.LIME_DYE, "\u00a7aRecipe Status: ENABLED", "\u00a77Players \u00a7acan \u00a77craft this recipe.", "", "\u00a7eClick to Disable") : this.makeItem(Material.GRAY_DYE, "\u00a7cRecipe Status: DISABLED", "\u00a77Players \u00a7ccannot \u00a77craft this recipe.", "", "\u00a7eClick to Enable");
        this.inventory.setItem(49, tableIcon);
        this.inventory.setItem(53, this.makeItem(Material.GREEN_STAINED_GLASS, "\u00a7aSave & Back", new String[0]));
    }

    private ItemStack getIngredientIconFromConfig(ConfigurationSection sec) {
        ArrayList<Object> lore;
        ItemStack stack;
        MatchType type;
        String typeStr = sec.getString("type", "MATERIAL");
        String value = sec.getString("value", "BEDROCK");
        int amount = sec.getInt("amount", 1);
        try {
            type = MatchType.valueOf(typeStr);
        }
        catch (IllegalArgumentException e) {
            type = MatchType.MATERIAL;
        }
        if (type == MatchType.BUFFED_ITEM) {
            BuffedItem bi = this.plugin.getItemManager().getBuffedItem(value);
            stack = bi != null ? new ItemBuilder(bi, (Plugin)this.plugin).build() : new ItemStack(Material.BARRIER);
        } else if (type == MatchType.EXACT) {
            stack = Serializer.fromBase64(value);
            if (stack == null) {
                stack = new ItemStack(Material.BARRIER);
            }
        } else {
            Material mat = Material.BEDROCK;
            if (type == MatchType.MATERIAL && (mat = Material.getMaterial((String)value)) == null) {
                mat = Material.BEDROCK;
            }
            stack = new ItemStack(mat);
        }
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return stack;
        }
        Object originalName = meta.hasDisplayName() ? meta.getDisplayName() : "\u00a7f" + this.formatMaterialName(stack.getType());
        if (amount > 1) {
            meta.displayName(ConfigManager.fromSection("\u00a7e" + amount + "x " + (String)originalName));
        } else if (type == MatchType.MATERIAL) {
            meta.displayName(ConfigManager.fromSection((String)originalName));
        }
        ArrayList<Object> arrayList = lore = meta.hasLore() ? new ArrayList<Object>(meta.lore()) : new ArrayList();
        if (!lore.isEmpty()) {
            lore.add(Component.empty());
        }
        lore.add(ConfigManager.fromSection("\u00a78----------------"));
        lore.add(ConfigManager.fromSection("\u00a77Type: \u00a7f" + type.name()));
        if (type == MatchType.MATERIAL || type == MatchType.BUFFED_ITEM) {
            lore.add(ConfigManager.fromSection("\u00a77Value: \u00a7e" + value));
        } else {
            lore.add(ConfigManager.fromSection("\u00a77Value: \u00a7e(Base64 Data)"));
        }
        lore.add(ConfigManager.fromSection("\u00a77Amount: \u00a7e" + amount));
        lore.add(Component.empty());
        lore.add(ConfigManager.fromSection("\u00a7eClick to Edit"));
        meta.lore(lore);
        stack.setItemMeta(meta);
        stack.setAmount(Math.max(1, amount));
        return stack;
    }

    private String formatMaterialName(Material material) {
        String name = material.name().toLowerCase().replace("_", " ");
        StringBuilder sb = new StringBuilder();
        for (String word : name.split(" ")) {
            sb.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return sb.toString().trim();
    }
}

