/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.active;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.active.ActiveItemSettingsMenu;
import io.github.altkat.BuffedItems.menu.active.CommandListMenu;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.selector.BuffedItemSelectorMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.DepletionAction;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class UsageLimitSettingsMenu
extends Menu {
    private final BuffedItems plugin;
    private final String itemId;

    public UsageLimitSettingsMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.itemId = playerMenuUtility.getItemToEditId();
    }

    @Override
    public String getMenuName() {
        return "Usage Limit: " + this.itemId;
    }

    @Override
    public int getSlots() {
        return 45;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        Material type = e.getCurrentItem().getType();
        if (type == Material.BARRIER && e.getSlot() == 44) {
            new ActiveItemSettingsMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.itemId);
        if (item == null) {
            return;
        }
        if (e.getSlot() == 10) {
            this.playerMenuUtility.setWaitingForChatInput(true);
            this.playerMenuUtility.setChatInputPath("usage-limit.max-usage");
            p.closeInventory();
            p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter Max Usage amount in chat (e.g. 50)."));
            p.sendMessage(ConfigManager.fromSection("\u00a77Current: " + String.valueOf(item.getMaxUses() > 0 ? Integer.valueOf(item.getMaxUses()) : "Unlimited (-1)")));
            p.sendMessage(ConfigManager.fromSection("\u00a77(Type 'cancel' to exit."));
            return;
        }
        if (e.getSlot() == 12) {
            DepletionAction current = item.getDepletionAction();
            DepletionAction next = current == DepletionAction.DISABLE ? DepletionAction.DESTROY : (current == DepletionAction.DESTROY ? DepletionAction.TRANSFORM : DepletionAction.DISABLE);
            ConfigManager.setItemValue(this.itemId, "usage-limit.action", next.name());
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            this.open();
            return;
        }
        if (e.getSlot() == 14 && type == Material.HOPPER) {
            new BuffedItemSelectorMenu(this.playerMenuUtility, this.plugin, BuffedItemSelectorMenu.SelectionContext.USAGE_LIMIT).open();
            return;
        }
        if (e.getSlot() == 16) {
            new CommandListMenu(this.playerMenuUtility, this.plugin, CommandListMenu.CommandContext.DEPLETION).open();
            return;
        }
        String configKey = null;
        String inputPath = null;
        String title = null;
        if (e.getSlot() == 28) {
            configKey = "usage-limit.lore";
            inputPath = "usage-limit.lore";
            title = "Usage Lore Line";
        } else if (e.getSlot() == 30) {
            configKey = "usage-limit.depleted-lore";
            inputPath = "usage-limit.depleted-lore";
            title = "Depleted Lore Line";
        } else if (e.getSlot() == 32) {
            configKey = "usage-limit.depleted-message";
            inputPath = "usage-limit.depleted-message";
            title = "Depleted Denial Message";
        } else if (e.getSlot() == 34) {
            configKey = "usage-limit.depletion-notification";
            inputPath = "usage-limit.depletion-notification";
            title = "Break Notification";
        }
        if (configKey != null) {
            if (e.getClick() == ClickType.RIGHT) {
                ConfigManager.setItemValue(this.itemId, configKey, null);
                p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aReset " + title + " to default."));
                this.open();
            } else {
                this.playerMenuUtility.setWaitingForChatInput(true);
                this.playerMenuUtility.setChatInputPath(inputPath);
                p.closeInventory();
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter new " + title + " in chat."));
                p.sendMessage(ConfigManager.fromSection("\u00a77Placeholders: {remaining_uses}, {total_uses}"));
                p.sendMessage(ConfigManager.fromSection("\u00a77Type 'cancel' to exit."));
            }
        }
    }

    @Override
    public void setMenuItems() {
        this.setFillerGlass();
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.itemId);
        if (item == null) {
            return;
        }
        int maxUses = item.getMaxUses();
        Object usageStatus = maxUses > 0 ? "\u00a7e" + maxUses : "\u00a7aUnlimited (-1)";
        this.inventory.setItem(10, this.makeItem(Material.REDSTONE, "\u00a7cMax Usage Limit", "\u00a77Current: " + (String)usageStatus, "", "\u00a7eClick to Edit"));
        DepletionAction action = item.getDepletionAction();
        Material actionIcon = Material.BARRIER;
        String actionDesc = "\u00a77Item becomes unusable.";
        if (action == DepletionAction.DESTROY) {
            actionIcon = Material.TNT;
            actionDesc = "\u00a7cItem is destroyed.";
        } else if (action == DepletionAction.TRANSFORM) {
            actionIcon = Material.CHEST;
            actionDesc = "\u00a7bItem transforms.";
        }
        this.inventory.setItem(12, this.makeItem(actionIcon, "\u00a76Depletion Action", "\u00a77Current: \u00a7f" + action.name(), actionDesc, "", "\u00a7eClick to Switch"));
        if (action == DepletionAction.TRANSFORM) {
            String targetId = item.getDepletionTransformId();
            String displayName = "\u00a7cNone";
            Object idLine = "";
            if (targetId != null) {
                BuffedItem targetItem = this.plugin.getItemManager().getBuffedItem(targetId);
                displayName = targetItem != null ? ConfigManager.toSection(ConfigManager.fromLegacy(targetItem.getDisplayName())) : "\u00a7cUnknown Item";
                idLine = "\u00a78(ID: " + targetId + ")";
            }
            this.inventory.setItem(14, this.makeItem(Material.HOPPER, "\u00a7dTransform Target", new String[]{"\u00a77The item to give upon depletion.", "", "\u00a77Current: " + displayName, idLine, "", "\u00a7eClick to Select"}));
        } else {
            this.inventory.setItem(14, this.makeItem(Material.MINECART, "\u00a78Transform Target", "\u00a77(Requires TRANSFORM action)"));
        }
        this.inventory.setItem(16, this.makeItem(Material.COMMAND_BLOCK, "\u00a76Depletion Commands", "\u00a77Manage commands executed when", "\u00a77the item usage reaches 0.", "", "\u00a77Current: \u00a7f" + item.getDepletionCommands().size() + " commands", "", "\u00a7eClick to Edit"));
        this.inventory.setItem(28, this.makeMessageItem(Material.PAPER, "Usage Lore", item.getUsageLore(maxUses > 0 ? maxUses : 1), "usage-limit-lore"));
        this.inventory.setItem(30, this.makeMessageItem(Material.BOOK, "Depleted Lore", item.getDepletedLore(), "usage-limit-broken-lore"));
        this.inventory.setItem(32, this.makeMessageItem(Material.WRITABLE_BOOK, "Denial Message", item.getDepletedMessage(), "usage-limit-depleted-message"));
        this.inventory.setItem(34, this.makeMessageItem(Material.BELL, "Break Notification", item.getDepletionNotification(), "usage-limit-break-notification"));
        this.inventory.setItem(44, this.makeItem(Material.BARRIER, "\u00a7cBack", new String[0]));
    }

    private ItemStack makeMessageItem(Material mat, String title, String currentVal, String defaultKey) {
        return this.makeItem(mat, "\u00a7e" + title, "\u00a77Current:", "\u00a7r" + ConfigManager.toSection(ConfigManager.fromLegacy(currentVal)), "", "\u00a7eLeft-Click to Edit", "\u00a7cRight-Click to Reset");
    }
}

