/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.menu.active;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.menu.active.ActiveItemSoundsMenu;
import io.github.altkat.BuffedItems.menu.active.ActiveItemVisualsMenu;
import io.github.altkat.BuffedItems.menu.active.CommandListMenu;
import io.github.altkat.BuffedItems.menu.active.CostListMenu;
import io.github.altkat.BuffedItems.menu.active.UsageLimitSettingsMenu;
import io.github.altkat.BuffedItems.menu.base.Menu;
import io.github.altkat.BuffedItems.menu.editor.ItemEditorMenu;
import io.github.altkat.BuffedItems.menu.passive.EffectListMenu;
import io.github.altkat.BuffedItems.menu.utility.ItemListMenu;
import io.github.altkat.BuffedItems.menu.utility.PlayerMenuUtility;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class ActiveItemSettingsMenu
extends Menu {
    private final BuffedItems plugin;
    private final String itemId;

    public ActiveItemSettingsMenu(PlayerMenuUtility playerMenuUtility, BuffedItems plugin) {
        super(playerMenuUtility);
        this.plugin = plugin;
        this.itemId = playerMenuUtility.getItemToEditId();
    }

    @Override
    public String getMenuName() {
        return "Active Settings: " + this.itemId;
    }

    @Override
    public int getSlots() {
        return 45;
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (e.getCurrentItem() == null) {
            return;
        }
        Material type = e.getCurrentItem().getType();
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.itemId);
        if (item == null) {
            new ItemListMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        if (type == Material.BARRIER && e.getSlot() == 44) {
            new ItemEditorMenu(this.playerMenuUtility, this.plugin).open();
            return;
        }
        switch (type) {
            case LEVER: {
                boolean newMode = !item.isActiveMode();
                ConfigManager.setItemValue(this.itemId, "active_mode", newMode);
                p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                this.open();
                break;
            }
            case CLOCK: {
                this.playerMenuUtility.setWaitingForChatInput(true);
                this.playerMenuUtility.setChatInputPath("active.cooldown");
                p.closeInventory();
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter the Cooldown (in seconds) in chat."));
                p.sendMessage(ConfigManager.fromSection("\u00a77(Current: " + item.getCooldown() + "s)"));
                break;
            }
            case COMPASS: {
                this.playerMenuUtility.setWaitingForChatInput(true);
                this.playerMenuUtility.setChatInputPath("active.duration");
                p.closeInventory();
                p.sendMessage(ConfigManager.fromSectionWithPrefix("\u00a7aEnter the Effect Duration (in seconds) in chat."));
                p.sendMessage(ConfigManager.fromSection("\u00a77(Current: " + item.getActiveDuration() + "s)"));
                break;
            }
            case COMMAND_BLOCK: {
                new CommandListMenu(this.playerMenuUtility, this.plugin, CommandListMenu.CommandContext.ACTIVE).open();
                break;
            }
            case LINGERING_POTION: {
                this.playerMenuUtility.setTargetSlot("ACTIVE");
                new EffectListMenu(this.playerMenuUtility, this.plugin, EffectListMenu.EffectType.POTION_EFFECT, "ACTIVE").open();
                break;
            }
            case NETHER_STAR: {
                this.playerMenuUtility.setTargetSlot("ACTIVE");
                new EffectListMenu(this.playerMenuUtility, this.plugin, EffectListMenu.EffectType.ATTRIBUTE, "ACTIVE").open();
                break;
            }
            case JUKEBOX: {
                new ActiveItemSoundsMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case PAINTING: {
                new ActiveItemVisualsMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case EMERALD: {
                new CostListMenu(this.playerMenuUtility, this.plugin).open();
                break;
            }
            case DIAMOND: {
                new UsageLimitSettingsMenu(this.playerMenuUtility, this.plugin).open();
            }
        }
    }

    @Override
    public void setMenuItems() {
        BuffedItem item = this.plugin.getItemManager().getBuffedItem(this.itemId);
        if (item == null) {
            return;
        }
        boolean isActive = item.isActiveMode();
        this.inventory.setItem(10, this.makeItem(Material.LEVER, isActive ? "\u00a7aActive Mode: ON" : "\u00a7cActive Mode: OFF", "\u00a77Enable/Disable right-click functionality.", "", "\u00a7eClick to Toggle"));
        this.inventory.setItem(12, this.makeItem(Material.CLOCK, "\u00a7bSet Cooldown", "\u00a77Current: \u00a7e" + item.getCooldown() + "s", "", "\u00a7eClick to Edit"));
        this.inventory.setItem(14, this.makeItem(Material.COMPASS, "\u00a7bSet Effect Duration", "\u00a77Current: \u00a7e" + item.getActiveDuration() + "s", "", "\u00a7eClick to Edit"));
        this.inventory.setItem(16, this.makeItem(Material.COMMAND_BLOCK, "\u00a76Manage Commands", "\u00a77Current: \u00a7e" + item.getActiveCommands().size() + " commands", "", "\u00a7eClick to Edit List"));
        this.inventory.setItem(19, this.makeItem(Material.LINGERING_POTION, "\u00a7dActive Potion Effects", "\u00a77Manage potion effects applied", "\u00a77when used.", "", "\u00a7eClick to Edit"));
        this.inventory.setItem(21, this.makeItem(Material.NETHER_STAR, "\u00a7bActive Attributes", "\u00a77Manage temporary attributes", "\u00a77given when used.", "", "\u00a7eClick to Edit"));
        this.inventory.setItem(23, this.makeItem(Material.PAINTING, "\u00a7eVisual Settings", "\u00a77Configure visual indicators:", "\u00a7f\u2022 Chat, Title, Action Bar", "\u00a7f\u2022 BossBar Settings", "\u00a7f\u2022 Custom Messages", "", "\u00a7eClick to Edit"));
        this.inventory.setItem(25, this.makeItem(Material.JUKEBOX, "\u00a76Sound Settings", "\u00a77Configure item sounds:", "\u00a7f\u2022 Success Sound", "\u00a7f\u2022 Cooldown Sound", "\u00a7f\u2022 Cost Fail Sound", "\u00a7f\u2022 Depletion Sounds", "", "\u00a7eClick to Edit"));
        this.inventory.setItem(28, this.makeItem(Material.EMERALD, "\u00a7aUsage Costs", "\u00a77Configure requirements to use this item.", "\u00a7f\u2022 Money, XP, Items, Health...", "", "\u00a7eClick to Manage"));
        this.inventory.setItem(30, this.makeItem(Material.DIAMOND, "\u00a7aUsage Limits", "\u00a77Limit how many times this item's", "\u00a77ability can be used.", "", "\u00a7f\u2022 Max Usage & Actions", "\u00a7f\u2022 Usage Lore", "\u00a7f\u2022 Depletion Messages", "\u00a7f\u2022 Transformation Logic", "", "\u00a7eClick to Manage"));
        this.inventory.setItem(44, this.makeItem(Material.BARRIER, "\u00a7cBack", new String[0]));
        this.setFillerGlass();
    }
}

