/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.item;

import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.handler.CustomModelDataHandler;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import io.github.altkat.BuffedItems.manager.config.ItemsConfig;
import io.github.altkat.BuffedItems.manager.cost.ICost;
import io.github.altkat.BuffedItems.manager.effect.EffectManager;
import io.github.altkat.BuffedItems.menu.selector.EnchantmentFinder;
import io.github.altkat.BuffedItems.utility.attribute.ParsedAttribute;
import io.github.altkat.BuffedItems.utility.item.BuffedItem;
import io.github.altkat.BuffedItems.utility.item.BuffedItemEffect;
import io.github.altkat.BuffedItems.utility.item.DepletionAction;
import io.github.altkat.BuffedItems.utility.item.ItemBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class ItemManager {
    private final BuffedItems plugin;
    private final Map<String, BuffedItem> buffedItems = new HashMap<String, BuffedItem>();
    private final Set<UUID> managedAttributeUUIDs = new HashSet<UUID>();
    private final CustomModelDataHandler cmdResolver;

    public ItemManager(BuffedItems plugin) {
        this.plugin = plugin;
        this.cmdResolver = new CustomModelDataHandler(plugin);
    }

    public void loadItems(boolean silent) {
        long startTime = System.currentTimeMillis();
        this.buffedItems.clear();
        this.managedAttributeUUIDs.clear();
        ConfigurationSection itemsSection = ItemsConfig.get().getConfigurationSection("items");
        if (itemsSection == null) {
            if (!silent) {
                ConfigManager.logInfo("&eNo items found in items.yml yet.");
            }
            return;
        }
        ConfigManager.sendDebugMessage(1, () -> "[ItemManager] Loading items from config...");
        int validItems = 0;
        int invalidItems = 0;
        ArrayList<String> itemsWithErrors = new ArrayList<String>();
        for (String itemId : itemsSection.getKeys(false)) {
            ConfigurationSection itemSection = itemsSection.getConfigurationSection(itemId);
            if (itemSection == null) {
                ConfigManager.sendDebugMessage(1, () -> "[ItemManager] Skipping null section for: " + itemId);
                continue;
            }
            BuffedItem loadedItem = this.parseItem(itemSection, itemId);
            if (!loadedItem.isValid()) {
                ++invalidItems;
                itemsWithErrors.add(itemId);
            } else {
                ++validItems;
            }
            this.buffedItems.put(itemId, loadedItem);
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        if (!silent) {
            ConfigManager.logInfo("&aLoaded &e" + this.buffedItems.size() + "&a buffed items from config (&e" + validItems + "&a valid, &e" + invalidItems + "&c with errors&a) in &e" + elapsedTime + "&ams");
            if (invalidItems > 0) {
                String separator = "============================================================";
                this.plugin.getLogger().warning(separator);
                this.plugin.getLogger().warning("\u26a0 " + invalidItems + " item(s) have configuration errors:");
                for (String itemId : itemsWithErrors) {
                    BuffedItem item = this.buffedItems.get(itemId);
                    this.plugin.getLogger().warning("  \u2022 " + itemId + " (" + item.getErrorMessages().size() + " error(s))");
                    if (!ConfigManager.isDebugLevelEnabled(1)) continue;
                    for (String error : item.getErrorMessages()) {
                        this.plugin.getLogger().warning("    - " + ConfigManager.stripLegacy(error));
                    }
                }
                this.plugin.getLogger().warning("Use /bi menu to view and fix these errors in-game.");
                this.plugin.getLogger().warning(separator);
            }
        }
        ConfigManager.sendDebugMessage(1, () -> "[ItemManager] Tracking " + this.managedAttributeUUIDs.size() + " attribute UUIDs");
    }

    public void reloadSingleItem(String itemId) {
        ConfigurationSection itemSection = ItemsConfig.get().getConfigurationSection("items." + itemId);
        BuffedItem oldItem = this.buffedItems.get(itemId);
        if (oldItem != null) {
            this.cleanupOldUUIDs(oldItem);
        }
        if (itemSection == null) {
            this.buffedItems.remove(itemId);
            ConfigManager.sendDebugMessage(1, () -> "[ItemManager] Unloaded deleted item: " + itemId);
            return;
        }
        BuffedItem newItem = this.parseItem(itemSection, itemId);
        this.buffedItems.put(itemId, newItem);
        ConfigManager.sendDebugMessage(1, () -> "[ItemManager] Reloaded single item: " + itemId + " (Valid: " + newItem.isValid() + ")");
    }

    private BuffedItem parseItem(ConfigurationSection itemSection, String itemId) {
        BuffedItem.AttributeMode attributeMode;
        int cooldown;
        Integer customModelData;
        String customModelDataRaw;
        String passivePerm;
        String activePerm;
        ConfigManager.sendDebugMessage(3, () -> "[ItemManager] Processing item: " + itemId);
        String displayName = itemSection.getString("display_name", "Default Name");
        List lore = itemSection.getStringList("lore");
        String materialName = itemSection.getString("material", "STONE");
        Material material = Material.matchMaterial((String)materialName);
        boolean glow = itemSection.getBoolean("glow", false);
        String permission = itemSection.getString("permission");
        if (permission != null && (permission.equals("NONE") || permission.trim().isEmpty())) {
            permission = null;
        }
        if ((activePerm = itemSection.getString("active_permission")) != null && (activePerm.equals("NONE") || activePerm.trim().isEmpty())) {
            activePerm = null;
        }
        if ((passivePerm = itemSection.getString("passive_permission")) != null && (passivePerm.equals("NONE") || passivePerm.trim().isEmpty())) {
            passivePerm = null;
        }
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (itemSection.contains("custom-model-data")) {
            Object cmdValue = itemSection.get("custom-model-data");
            customModelDataRaw = cmdValue instanceof Integer ? String.valueOf(cmdValue) : (cmdValue instanceof String ? (String)cmdValue : null);
            if (customModelDataRaw != null) {
                CustomModelDataHandler.CustomModelData resolved = this.cmdResolver.resolve(customModelDataRaw, itemId);
                if (resolved != null) {
                    customModelData = resolved.getValue();
                    ConfigManager.sendDebugMessage(3, () -> "[ItemManager] Item " + itemId + " resolved custom-model-data: " + customModelDataRaw + " -> " + customModelData + " (source: " + String.valueOf((Object)resolved.getSource()) + ")");
                } else {
                    customModelData = null;
                    String errorMsg = "Invalid custom-model-data: '" + customModelDataRaw + "'";
                    errorMessages.add("\u00a7c" + (String)errorMsg);
                    ConfigManager.sendDebugMessage(1, () -> "[Item: " + itemId + "] " + errorMsg);
                }
            } else {
                customModelData = null;
            }
        } else {
            customModelDataRaw = null;
            customModelData = null;
        }
        if (material == null) {
            String errorMsg = "Invalid Material: '" + materialName + "'";
            errorMessages.add("\u00a7c" + errorMsg);
            ConfigManager.sendDebugMessage(1, () -> "[Item: " + itemId + "] " + errorMsg);
            material = Material.BARRIER;
        }
        HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
        ConfigurationSection flagsSection = itemSection.getConfigurationSection("flags");
        if (flagsSection != null) {
            for (String flagKey : flagsSection.getKeys(false)) {
                flags.put(flagKey.toUpperCase(), flagsSection.getBoolean(flagKey, false));
            }
            ConfigManager.sendDebugMessage(3, () -> "[ItemManager] Item " + itemId + " has " + flags.size() + " custom flags");
        }
        int passiveEffectsHash = 0;
        HashMap<String, BuffedItemEffect> effects = new HashMap<String, BuffedItemEffect>();
        ConfigurationSection effectsSection = itemSection.getConfigurationSection("effects");
        if (effectsSection != null) {
            ConfigManager.sendDebugMessage(3, () -> "[ItemManager] Item " + itemId + " has effects section");
            List sortedSlots = effectsSection.getKeys(false).stream().sorted().collect(Collectors.toList());
            for (Object slot : sortedSlots) {
                Object effectString2;
                ConfigurationSection slotSection = effectsSection.getConfigurationSection((String)slot);
                if (slotSection == null) continue;
                HashMap<PotionEffectType, Integer> potionEffects = new HashMap<PotionEffectType, Integer>();
                ArrayList<ParsedAttribute> parsedAttributes = new ArrayList<ParsedAttribute>();
                List potionEffectStrings = slotSection.getStringList("potion_effects");
                ConfigManager.sendDebugMessage(3, () -> ItemManager.lambda$parseItem$11(itemId, (String)slot, potionEffectStrings));
                for (Object effectString2 : potionEffectStrings) {
                    try {
                        String[] parts = ((String)effectString2).split(";");
                        String effectName = parts[0].toUpperCase();
                        PotionEffectType type = PotionEffectType.getByName((String)effectName);
                        if (type == null) {
                            String errorMsg = "Invalid PotionEffect: '" + effectName + "'";
                            errorMessages.add("\u00a7c" + errorMsg);
                            ConfigManager.sendDebugMessage(1, () -> "[Item: " + itemId + "] " + errorMsg);
                            continue;
                        }
                        int level = Integer.parseInt(parts[1]);
                        potionEffects.put(type, level);
                    }
                    catch (Exception e) {
                        String errorMsg = "Corrupt PotionEffect format: \u00a7e'" + (String)effectString2 + "'";
                        errorMessages.add("\u00a7c" + errorMsg);
                        ConfigManager.sendDebugMessage(1, () -> "[Item: " + itemId + "] " + errorMsg + " | Error: " + e.getMessage());
                    }
                }
                List originalAttributeStrings = slotSection.getStringList("attributes");
                ConfigManager.sendDebugMessage(3, () -> ItemManager.lambda$parseItem$14(itemId, (String)slot, originalAttributeStrings));
                effectString2 = originalAttributeStrings.iterator();
                while (effectString2.hasNext()) {
                    String errorMsg;
                    String attrString = (String)effectString2.next();
                    try {
                        String[] parts = attrString.split(";");
                        if (parts.length != 3) {
                            throw new IllegalArgumentException("Attribute string must have 3 parts separated by ';'. Found: " + attrString);
                        }
                        Attribute attribute = Attribute.valueOf((String)parts[0].toUpperCase());
                        AttributeModifier.Operation operation = AttributeModifier.Operation.valueOf((String)parts[1].toUpperCase());
                        double amount = Double.parseDouble(parts[2]);
                        UUID modifierUUID = EffectManager.getUuidForItem(itemId, ((String)slot).toUpperCase(), attribute);
                        parsedAttributes.add(new ParsedAttribute(attribute, operation, amount, modifierUUID));
                        this.managedAttributeUUIDs.add(modifierUUID);
                        ConfigManager.sendDebugMessage(4, () -> "[ItemManager] Pre-parsed and cached attribute UUID: " + String.valueOf(modifierUUID) + " for " + attribute.name());
                    }
                    catch (IllegalArgumentException e) {
                        errorMsg = "Invalid Attribute or Operation: '" + attrString + "'. Error: " + e.getMessage();
                        errorMessages.add("\u00a7c" + (String)errorMsg);
                        ConfigManager.sendDebugMessage(1, () -> "[Item: " + itemId + "] " + errorMsg);
                    }
                    catch (Exception e) {
                        errorMsg = "Corrupt Attribute format: \u00a7e'" + attrString + "'";
                        errorMessages.add("\u00a7c" + errorMsg);
                        ConfigManager.sendDebugMessage(1, () -> "[Item: " + itemId + "] " + errorMsg + " | Error: " + e.getMessage());
                    }
                }
                effects.put(((String)slot).toUpperCase(), new BuffedItemEffect(potionEffects, parsedAttributes));
                passiveEffectsHash = Objects.hash(passiveEffectsHash, slot, potionEffectStrings, originalAttributeStrings);
            }
        }
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        List enchantmentStrings = itemSection.getStringList("enchantments");
        ConfigManager.sendDebugMessage(3, () -> "[ItemManager] Item " + itemId + " has " + enchantmentStrings.size() + " enchantments listed.");
        for (String enchString : enchantmentStrings) {
            String errorMsg;
            try {
                String[] parts = enchString.split(";");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Must be format ENCHANTMENT_NAME;LEVEL");
                }
                String enchName = parts[0].toUpperCase();
                Enchantment enchantment = EnchantmentFinder.findEnchantment(enchName, this.plugin);
                if (enchantment == null) {
                    String errorMsg2 = "Invalid Enchantment name: '" + enchName + "'";
                    errorMessages.add("\u00a7c" + errorMsg2);
                    ConfigManager.sendDebugMessage(1, () -> "[Item: " + itemId + "] " + errorMsg2);
                    continue;
                }
                int level = Integer.parseInt(parts[1]);
                if (level <= 0) {
                    ConfigManager.sendDebugMessage(3, () -> "[Item: " + itemId + "] Enchantment level for " + enchName + " must be positive, found: " + level + ". Skipping.");
                    continue;
                }
                if (enchantments.containsKey(enchantment)) {
                    ConfigManager.sendDebugMessage(3, () -> "[Item: " + itemId + "] Duplicate enchantment found: '" + enchName + "'. Using the first definition.");
                    continue;
                }
                enchantments.put(enchantment, level);
                ConfigManager.sendDebugMessage(3, () -> "[ItemManager] Parsed enchantment: " + enchantment.getKey().getKey() + " Level: " + level);
            }
            catch (NumberFormatException e) {
                errorMsg = "Invalid Enchantment level format: \u00a7e'" + enchString + "'";
                errorMessages.add("\u00a7c" + errorMsg);
                ConfigManager.sendDebugMessage(1, () -> "[Item: " + itemId + "] " + errorMsg);
            }
            catch (Exception e) {
                errorMsg = "Corrupt Enchantment format: \u00a7e'" + enchString + "' Error: " + e.getMessage();
                errorMessages.add("\u00a7c" + errorMsg);
                ConfigManager.sendDebugMessage(1, () -> "[Item: " + itemId + "] " + errorMsg);
            }
        }
        ConfigurationSection activeModeSection = itemSection.getConfigurationSection("active-mode");
        boolean activeMode = false;
        int activeDuration = 0;
        int maxUses = 0;
        String durabilityLore = null;
        String depletedLore = null;
        String depletedMessage = null;
        String depletionNotification = null;
        DepletionAction depletionAction = DepletionAction.DISABLE;
        String depletionTransformId = null;
        ArrayList<String> depletionCommands = new ArrayList();
        List<String> activeCommands = new ArrayList();
        boolean vChat = true;
        boolean vTitle = true;
        boolean vActionBar = true;
        boolean vBossBar = true;
        String bbColor = "RED";
        String bbStyle = "SOLID";
        String msgChat = null;
        String msgTitle = null;
        String msgSubtitle = null;
        String msgActionBar = null;
        String msgBossBar = null;
        String soundSuccess = null;
        String soundCooldown = null;
        String soundCostFail = null;
        String soundDepletion = null;
        String soundDepletedTry = null;
        ArrayList<ICost> costs = new ArrayList<ICost>();
        BuffedItemEffect activeEffectsObj = null;
        if (activeModeSection != null) {
            ConfigurationSection activeEffectsSection;
            ConfigurationSection soundsSection;
            ConfigurationSection visualsSection;
            activeMode = activeModeSection.getBoolean("enabled", false);
            cooldown = activeModeSection.getInt("cooldown", 0);
            if (activeModeSection.isConfigurationSection("usage-limit")) {
                ConfigurationSection durabilitySection = activeModeSection.getConfigurationSection("usage-limit");
                maxUses = durabilitySection.getInt("max-usage", -1);
                durabilityLore = durabilitySection.getString("lore", null);
                depletedLore = durabilitySection.getString("depleted-lore", null);
                depletedMessage = durabilitySection.getString("depleted-message", null);
                depletionNotification = durabilitySection.getString("depletion-notification", null);
                String actionStr = durabilitySection.getString("action", "DISABLE");
                try {
                    depletionAction = DepletionAction.valueOf(actionStr.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    errorMessages.add("\u00a7cInvalid Depletion Action: " + actionStr + " (Defaulting to DISABLE)");
                }
                depletionTransformId = durabilitySection.getString("transform-item", null);
                depletionCommands = durabilitySection.getStringList("commands");
            }
            activeDuration = activeModeSection.getInt("duration", 0);
            activeCommands = activeModeSection.getStringList("commands");
            if (cooldown < 0) {
                errorMessages.add("\u00a7cActive Mode: Cooldown cannot be negative.");
            }
            if (activeDuration < 0) {
                errorMessages.add("\u00a7cActive Mode: Duration cannot be negative.");
            }
            if (activeMode) {
                ConfigManager.sendDebugMessage(1, () -> "[ItemManager] Item " + itemId + " is loaded as ACTIVE item (CD: " + cooldown + "s)");
            }
            if ((visualsSection = activeModeSection.getConfigurationSection("visuals")) != null) {
                vChat = visualsSection.getBoolean("chat", true);
                vTitle = visualsSection.getBoolean("title", true);
                vActionBar = visualsSection.getBoolean("action-bar", true);
                vBossBar = visualsSection.getBoolean("boss-bar", true);
                bbColor = visualsSection.getString("boss-bar-color", "RED");
                try {
                    BarColor.valueOf((String)bbColor);
                }
                catch (IllegalArgumentException e) {
                    errorMessages.add("\u00a7cActive Mode Error: Invalid BossBar Color '" + bbColor + "'. Valid: RED, BLUE, GREEN, etc.");
                }
                bbStyle = visualsSection.getString("boss-bar-style", "SOLID");
                try {
                    BarStyle.valueOf((String)bbStyle);
                }
                catch (IllegalArgumentException e) {
                    errorMessages.add("\u00a7cActive Mode Error: Invalid BossBar Style '" + bbStyle + "'. Valid: SOLID, SEGMENTED_6, etc.");
                }
                msgChat = visualsSection.getString("messages.cooldown-chat");
                msgTitle = visualsSection.getString("messages.cooldown-title");
                msgSubtitle = visualsSection.getString("messages.cooldown-subtitle");
                msgActionBar = visualsSection.getString("messages.cooldown-action-bar");
                msgBossBar = visualsSection.getString("messages.cooldown-boss-bar");
            }
            if ((soundsSection = activeModeSection.getConfigurationSection("sounds")) != null) {
                soundSuccess = this.validateSound(soundsSection.getString("success"), "success", errorMessages);
                soundCooldown = this.validateSound(soundsSection.getString("cooldown"), "cooldown", errorMessages);
                soundCostFail = this.validateSound(soundsSection.getString("cost-fail"), "cost-fail", errorMessages);
                soundDepletion = this.validateSound(soundsSection.getString("depletion"), "depletion", errorMessages);
                soundDepletedTry = this.validateSound(soundsSection.getString("depleted-try"), "depleted-try", errorMessages);
            }
            for (int i = 0; i < activeCommands.size(); ++i) {
                int end;
                int start;
                String cmd = (String)activeCommands.get(i);
                if (cmd.contains("[chance:")) {
                    try {
                        double chanceVal;
                        start = cmd.indexOf("[chance:") + 8;
                        end = cmd.indexOf("]", start);
                        if (end != -1 && ((chanceVal = Double.parseDouble(cmd.substring(start, end))) < 0.0 || chanceVal > 100.0)) {
                            errorMessages.add("\u00a7cActive Mode Error: Command chance must be 0-100. Found: " + chanceVal + " in command #" + (i + 1));
                        }
                    }
                    catch (NumberFormatException e) {
                        errorMessages.add("\u00a7cActive Mode Error: Invalid chance number format in command #" + (i + 1));
                    }
                }
                if (!cmd.contains("[delay:")) continue;
                try {
                    long delayVal;
                    start = cmd.indexOf("[delay:") + 7;
                    end = cmd.indexOf("]", start);
                    if (end == -1 || (delayVal = Long.parseLong(cmd.substring(start, end))) >= 0L) continue;
                    errorMessages.add("\u00a7cActive Mode Error: Command delay cannot be negative. Found: " + delayVal + " in command #" + (i + 1));
                    continue;
                }
                catch (NumberFormatException e) {
                    errorMessages.add("\u00a7cActive Mode Error: Invalid delay number format in command #" + (i + 1));
                }
            }
            if (activeModeSection.contains("costs")) {
                List costList = activeModeSection.getMapList("costs");
                for (int i = 0; i < costList.size(); ++i) {
                    String type;
                    Map rawMap = (Map)costList.get(i);
                    try {
                        ICost cost = this.plugin.getCostManager().parseCost(rawMap);
                        if (cost != null) {
                            costs.add(cost);
                            continue;
                        }
                        type = String.valueOf(rawMap.get("type"));
                        errorMessages.add("\u00a7cActive Mode Error: Invalid Cost at index " + (i + 1) + " (Unknown Type: " + type + ")");
                        continue;
                    }
                    catch (Exception e) {
                        type = String.valueOf(rawMap.get("type"));
                        errorMessages.add("\u00a7cActive Mode Error: " + e.getMessage() + " (Type: " + type + ")");
                    }
                }
                ArrayList<ICost> finalCosts = costs;
                ConfigManager.sendDebugMessage(3, () -> "[ItemManager] Loaded " + finalCosts.size() + " costs for item: " + itemId);
            }
            if ((activeEffectsSection = activeModeSection.getConfigurationSection("effects")) != null) {
                HashMap<PotionEffectType, Integer> activePotions = new HashMap<PotionEffectType, Integer>();
                for (String effectString : activeEffectsSection.getStringList("potion_effects")) {
                    try {
                        String[] parts = effectString.split(";");
                        if (parts.length < 2) {
                            throw new IllegalArgumentException("Missing level");
                        }
                        PotionEffectType type = PotionEffectType.getByName((String)parts[0].toUpperCase());
                        if (type == null) {
                            throw new IllegalArgumentException("Invalid potion type: " + parts[0]);
                        }
                        int level = Integer.parseInt(parts[1]);
                        if (level <= 0) {
                            throw new IllegalArgumentException("Level must be positive");
                        }
                        activePotions.put(type, level);
                    }
                    catch (Exception e) {
                        errorMessages.add("\u00a7cActive Mode Error: " + e.getMessage() + " in '" + effectString + "'");
                    }
                }
                ArrayList<ParsedAttribute> activeAttributes = new ArrayList<ParsedAttribute>();
                for (String attrString : activeEffectsSection.getStringList("attributes")) {
                    try {
                        String[] parts = attrString.split(";");
                        if (parts.length < 3) {
                            throw new IllegalArgumentException("Invalid format");
                        }
                        Attribute attribute = Attribute.valueOf((String)parts[0].toUpperCase());
                        AttributeModifier.Operation operation = AttributeModifier.Operation.valueOf((String)parts[1].toUpperCase());
                        double amount = Double.parseDouble(parts[2]);
                        activeAttributes.add(new ParsedAttribute(attribute, operation, amount, UUID.randomUUID()));
                    }
                    catch (IllegalArgumentException e) {
                        errorMessages.add("\u00a7cActive Mode Error: Invalid Attribute/Operation in '" + attrString + "'");
                    }
                    catch (Exception e) {
                        errorMessages.add("\u00a7cActive Mode Error: Corrupt attribute format '" + attrString + "'");
                    }
                }
                activeEffectsObj = new BuffedItemEffect(activePotions, activeAttributes);
            }
        } else {
            durabilityLore = null;
            maxUses = -1;
            cooldown = 0;
        }
        if (activeEffectsObj == null) {
            activeEffectsObj = new BuffedItemEffect(new HashMap<PotionEffectType, Integer>(), new ArrayList<ParsedAttribute>());
        }
        String attrModeStr = itemSection.getString("attribute_mode", "STATIC").toUpperCase();
        try {
            attributeMode = BuffedItem.AttributeMode.valueOf(attrModeStr);
        }
        catch (IllegalArgumentException e) {
            attributeMode = BuffedItem.AttributeMode.STATIC;
            errorMessages.add("\u00a7cInvalid attribute_mode '" + attrModeStr + "'. Defaulting to STATIC.");
        }
        if (attributeMode == BuffedItem.AttributeMode.DYNAMIC) {
            ConfigManager.sendDebugMessage(1, () -> "[ItemManager] Item " + itemId + " is set to DYNAMIC attribute mode.");
        }
        boolean hasPlaceholders = (displayName + lore.toString()).contains("%");
        HashMap stableEnchants = new HashMap();
        enchantments.forEach((ench, lvl) -> stableEnchants.put(ench.getKey().getKey(), lvl));
        int updateHash = Objects.hash(displayName, lore, material.name(), glow, customModelData, flags, stableEnchants, attributeMode.name(), passiveEffectsHash, activeMode, maxUses, durabilityLore, depletedLore);
        BuffedItem finalBuffedItem = new BuffedItem(itemId, displayName, lore, material, glow, effects, permission, activePerm, passivePerm, flags, enchantments, customModelData, customModelDataRaw, activeMode, cooldown, maxUses, durabilityLore, depletedLore, depletedMessage, depletionNotification, activeDuration, activeCommands, vChat, vTitle, vActionBar, vBossBar, bbColor, bbStyle, activeEffectsObj, msgChat, msgTitle, msgSubtitle, msgActionBar, msgBossBar, soundSuccess, soundCooldown, soundCostFail, soundDepletion, soundDepletedTry, depletionAction, depletionTransformId, depletionCommands, attributeMode, costs, updateHash, hasPlaceholders);
        for (String errorMsg : errorMessages) {
            finalBuffedItem.addErrorMessage(errorMsg);
        }
        ItemStack stack = new ItemBuilder(finalBuffedItem, (Plugin)this.plugin).build();
        finalBuffedItem.setCachedItem(stack);
        return finalBuffedItem;
    }

    private void cleanupOldUUIDs(BuffedItem item) {
        if (item == null || item.getEffects() == null) {
            return;
        }
        ConfigManager.sendDebugMessage(2, () -> "[ItemManager] Cleaning up old UUIDs for: " + item.getId());
        for (BuffedItemEffect effect : item.getEffects().values()) {
            if (effect.getParsedAttributes() == null) continue;
            for (ParsedAttribute attr : effect.getParsedAttributes()) {
                this.managedAttributeUUIDs.remove(attr.getUuid());
            }
        }
    }

    private String validateSound(String soundString, String type, List<String> errors) {
        if (soundString == null) {
            return null;
        }
        if (soundString.equalsIgnoreCase("NONE")) {
            return "NONE";
        }
        String[] parts = soundString.split(";");
        String soundName = parts[0];
        if (!soundName.contains(":")) {
            try {
                Sound.valueOf((String)soundName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                errors.add("\u00a7cActive Mode Error: Invalid Sound name '" + soundName + "' in '" + type + "'.");
            }
        }
        if (parts.length > 1) {
            try {
                Float.parseFloat(parts[1]);
            }
            catch (NumberFormatException e) {
                errors.add("\u00a7cActive Mode Error: Invalid volume number in '" + type + "' sound.");
            }
        }
        if (parts.length > 2) {
            try {
                Float.parseFloat(parts[2]);
            }
            catch (NumberFormatException e) {
                errors.add("\u00a7cActive Mode Error: Invalid pitch number in '" + type + "' sound.");
            }
        }
        return soundString;
    }

    public boolean isBuffedItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        return item.getItemMeta().getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "buffeditem_id"), PersistentDataType.STRING);
    }

    public BuffedItem getBuffedItem(String itemId) {
        return this.buffedItems.get(itemId);
    }

    public Map<String, BuffedItem> getLoadedItems() {
        return new HashMap<String, BuffedItem>(this.buffedItems);
    }

    public Set<UUID> getManagedAttributeUUIDs() {
        return this.managedAttributeUUIDs;
    }

    private static /* synthetic */ String lambda$parseItem$14(String itemId, String slot, List originalAttributeStrings) {
        return "[ItemManager] Item " + itemId + " slot " + slot + " has " + originalAttributeStrings.size() + " attributes";
    }

    private static /* synthetic */ String lambda$parseItem$11(String itemId, String slot, List potionEffectStrings) {
        return "[ItemManager] Item " + itemId + " slot " + slot + " has " + potionEffectStrings.size() + " potion effects";
    }
}

