/*
 * Decompiled with CFR 0.152.
 */
package io.github.altkat.BuffedItems.manager.config;

import com.google.common.base.Charsets;
import io.github.altkat.BuffedItems.BuffedItems;
import io.github.altkat.BuffedItems.manager.config.ConfigManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigUpdater {
    public static void update(BuffedItems plugin, String fileName) {
        String userHeader;
        String defaultHeader;
        File configFile = new File(plugin.getDataFolder(), fileName);
        YamlConfiguration defaultConfig = null;
        try {
            InputStream resource = plugin.getResource(fileName);
            if (resource == null) {
                return;
            }
            try (InputStreamReader reader = new InputStreamReader(resource, Charsets.UTF_8);){
                defaultConfig = YamlConfiguration.loadConfiguration((Reader)reader);
            }
        }
        catch (Exception e) {
            ConfigManager.logInfo("&cFailed to load default " + fileName + " for update check: " + e.getMessage());
            return;
        }
        if (!configFile.exists()) {
            return;
        }
        YamlConfiguration userConfig = YamlConfiguration.loadConfiguration((File)configFile);
        boolean needsSave = false;
        if (fileName.equals("config.yml")) {
            String[] obsoleteKeys;
            for (String key : obsoleteKeys = new String[]{"auto-save-interval-minutes", "messages.protection-prevent-smithing-use", "messages.protection-prevent-crafting-use"}) {
                if (!userConfig.contains(key)) continue;
                userConfig.set(key, null);
                needsSave = true;
                ConfigManager.logInfo("&eRemoved obsolete key '" + key + "' from " + fileName);
            }
        }
        if (!(defaultHeader = defaultConfig.options().header()).equals(userHeader = userConfig.options().header())) {
            needsSave = true;
            ConfigManager.sendDebugMessage(1, () -> "[Config] Header update detected for: " + fileName);
        }
        int keysAdded = 0;
        for (String key : defaultConfig.getKeys(true)) {
            if (fileName.equals("items.yml") && key.startsWith("items.") || fileName.equals("upgrades.yml") && key.startsWith("upgrades.") || fileName.equals("sets.yml") && key.startsWith("sets.") || fileName.equals("recipes.yml") && key.startsWith("recipes.") || userConfig.contains(key)) continue;
            userConfig.set(key, defaultConfig.get(key));
            ++keysAdded;
        }
        if (keysAdded > 0 || needsSave) {
            try {
                userConfig.options().copyHeader(true);
                userConfig.options().header(defaultConfig.options().header());
                userConfig.save(configFile);
                ConfigManager.logInfo("&aSuccessfully added " + keysAdded + " new key(s) to " + fileName + ".");
            }
            catch (IOException e) {
                ConfigManager.logInfo("&cFailed to save updated " + fileName + ": " + e.getMessage());
            }
        }
    }
}

